# -*- coding: UTF-8 -*-

from frameone.base.constants import CheckStatus, CheckResult
from frameone.util import baseUtil, contextUtil
from frameone.cli import cliUtil

srcVersionCheckList = ["V300R001C00", "V300R001C00SPC100", "V300R001C01"]
minUpgradeVersion = "V300R001C01SPC100"
checkDeviceList = ["Dorado6000 V3", "Dorado5000 V3"]


def execute(dataDict):
    dataDict['checkType'] = "PRECHECK"
    logger = contextUtil.getLogger(dataDict)
    logger.info("Enter CliLunWritePolicyCheck.")

    # 检查设备版本，只有满足特定的设备型号和目标版本才进行该检查
    devType = contextUtil.getDevType(dataDict)
    currentVersion = contextUtil.getCurVersion(dataDict)
    upgradeVersion = contextUtil.getTargetVersion(dataDict)
    logger.info("upgradeVersion is  %s,currentVersion is %s" %(upgradeVersion,currentVersion))
    if currentVersion not in srcVersionCheckList or devType not in checkDeviceList or upgradeVersion < minUpgradeVersion:
        logger.info("The device not need check lun write policy.")
        return (CheckStatus.NO_SUPPORT, "", "")
    
    checkRet = LunWritePolicyCheckStatus(dataDict).check()
    return checkRet.toScriptResult()

class LunWritePolicyCheckStatus():
    def __init__(self, dataDict):
        self.logger = contextUtil.getLogger(dataDict)
        self.originInfos = []
        self.lang = contextUtil.getLang(dataDict)
        self.context = dataDict
        self.commonMsg = baseUtil.getMsg(self.lang, "query.result.abnormal")
    
    def check(self):
        try:
            self.ssh = contextUtil.getCLI(self.context)
            cmd = "show lun general |filterColumn include columnList=ID,Write\sPolicy,Remote\sLUN\sWWN|filterRow column=Write\sPolicy predict=equal_to value=Write\sThrough logicOp=and column=Remote\sLUN\sWWN predict=equal_to value=--"
            (ok, cliRet, errorMsg) = cliUtil.excuteCmdInCliMode(self.ssh, cmd, True, self.lang)
            self.originInfos.append(cliRet)
            if cliUtil.queryResultWithNoRecord(cliRet):
                self.logger.info("Get lun is none")
                return CheckResult(CheckStatus.PASS, self.originInfos)

            if ok != True:
                self.logger.error("Get lun write policy failed.")
                return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)
            
            # 检查每个ID的运行模式
            cliRet2List = cliUtil.getHorizontalNostandardCliRet(cliRet)
            if len(cliRet2List) == 0:
                self.logger.info("lun length is zero.")
                return CheckResult(CheckStatus.PASS, self.originInfos)
            errorLunList = []
            for item in cliRet2List:
                errorLunList.append(str(item.get("ID")))

            errMsg = baseUtil.getMsg(self.lang, "CliLunWritePolicyCheck.nopass", ",".join(errorLunList))
            return CheckResult(CheckStatus.NOTPASS, self.originInfos, errMsg)

        except Exception as e:
            self.logger.error("lun write policy check exception.[%s]" % unicode(e))
            return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)
          
       
