# -*- coding: UTF-8 -*-
import traceback
from frameone.util import contextUtil, baseUtil
from frameone.cli import cliUtil
from frameone.base.constants import CheckStatus, CheckResult

SRC_VRC_CHECKLIST = ["V300R001C01"]
CHECK_DEV_LIST = ["Dorado6000 V3"]
USABLE_MGMT_PORTLIST =["CTE0.SMM0.MGMT","CTE1.SMM1.MGMT"]
#执行入口
def execute(dataDict):
    checkResult = MgmtIpCheck(dataDict).check()
    return checkResult.toScriptResult()

class MgmtIpCheck():
    def __init__(self, context):
        self.context = context
        self.logger = contextUtil.getLogger(context)

        self.lang = contextUtil.getLang(context)
        self.commonMsg = baseUtil.getMsg(self.lang, "query.result.abnormal")
        self.originInfos = []

    def check(self):
        try:
            devType = contextUtil.getDevType(self.context)
            currentVRC = baseUtil.getVRCVersion(contextUtil.getCurVersion(self.context))
            upgradeVRC = baseUtil.getVRCVersion(contextUtil.getTargetVersion(self.context))

            #check in the special version and device type
            if currentVRC not in SRC_VRC_CHECKLIST or devType not in CHECK_DEV_LIST:
                return CheckResult(CheckStatus.NO_SUPPORT, self.originInfos)

            #check when upgrading the upper VRC version
            if currentVRC == upgradeVRC:
                return CheckResult(CheckStatus.NO_SUPPORT, self.originInfos)

            #only check 4 controllers
            self.ssh = contextUtil.getCLI(self.context)
            ctrlRet = cliUtil.getControllerIdList(self.ssh, self.lang)
            self.originInfos.append("ctroller id=%s" % ctrlRet[1])
            if not ctrlRet[0]:
                return CheckResult(CheckStatus.NOCHECK, self.originInfos)

            if len(ctrlRet[1]) != 4:
                 return CheckResult(CheckStatus.NO_SUPPORT, self.originInfos)

            toolIp = contextUtil.getIp(self.context)
            cmd = "show system management_ip"
            excuteRet = cliUtil.excuteCmdInCliMode(self.ssh, cmd, True, self.lang)
            self.originInfos.append(excuteRet[1])
            if excuteRet[0] != True:
                self.logger.info("Cannot get management info")
                return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)
            mgmtIpInfo = cliUtil.getVerticalCliRet(excuteRet[1])
            if not mgmtIpInfo:
                return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)

            (ipv4List, ipv6List) = self.getUsableIp(mgmtIpInfo)
            if baseUtil.isIpV4(toolIp):
                self.logger.info("check ipv4")
                if toolIp not in ipv4List:
                    errMsg = baseUtil.getMsg(self.lang, "preCheckMgmtIP.nopass")
                    return CheckResult(CheckStatus.NOTPASS, self.originInfos, errMsg)
            else:
                self.logger.info("check ipv6")
                if baseUtil.formatIpv6(toolIp) not in ipv6List:
                    errMsg = baseUtil.getMsg(self.lang, "preCheckMgmtIP.nopass")
                    return CheckResult(CheckStatus.NOTPASS, self.originInfos, errMsg)
            return CheckResult(CheckStatus.PASS, self.originInfos)
        except:
            self.logger.error('Connect device exception:%s.' % traceback.format_exc())
            return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)

    def getUsableIp(self, mgmtIpInfo):
        '''
        @summary: get usable ip list
        '''
        ipv4List = []
        ipv6List = []
        for ipInfo in mgmtIpInfo:
            portId = ipInfo.get("Port ID")
            if portId not in USABLE_MGMT_PORTLIST:
                continue

            ipv4 = ipInfo.get("IPv4 Address")
            ipv4List.append(ipv4)

            ipv6 = baseUtil.formatIpv6(ipInfo.get("IPv6 Address"))
            ipv6List.append(ipv6)

        return (ipv4List, ipv6List)
