# -*- coding: UTF-8 -*-
from business.common import common

from frameone.util import contextUtil

from cbb.business.checkitems.ad_domian_connectivity_check import (
    AdDomainConnCheck,
)
from cbb.frame.checkitem.context_adapter import UpgradeEvalContext


def execute(context):
    """
    AD连通性检查
    :param context:
    :return:
    """
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    upd_context = UpgradeEvalContext(context)
    check_obj = AdDomainConnCheck(context)
    status, err_msg = check_obj.check()
    status, cli_ret, err_msg = upd_context.get_result(
        status, err_msg, check_obj.get_origin_info()
    )
    logger.logInfo(u"status:{}, err_msg:{}, cli_ret:{}".format(
        status, err_msg, cli_ret))
    return status, cli_ret, err_msg
