# -*- coding: UTF-8 -*-
from business.common import common
from frameone.util import contextUtil,baseUtil
from frameone.cli import cliUtil

ECC_RISK_CUR_VER = "V300R001C01SPC100"
ECC_RISK_DEST_VER = "V300R001C21SPC100"
ECC_RISK_PATCH_PKG_VER = "V300R001C21SPH108"

def execute(context):
    '''
        背景：升级场景，控制器内存单BIT ECC过多，导致控制器升级后被隔离。
        检查标准：如果当前阵列产品版本为Dorado V300R001C01SPC100，
        升级目标版本为Dorado V300R001C21SPC100，则检查不通过；否则检查通过。
    '''

    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    errMsg = ""
    allCliRet = ""

    try:
        curDeviceVersion = contextUtil.getCurVersion(context)
        destVersion = contextUtil.getTargetVersion(context)

        allCliRet = "Device version:%s\nUpgrade package version:%s\n" %(curDeviceVersion, destVersion)
        logger.logInfo("current Device Version = %s, dest version=%s " % (curDeviceVersion, destVersion))
        if curDeviceVersion != ECC_RISK_CUR_VER or destVersion != ECC_RISK_DEST_VER:
            return common.getUpgEvaluationRs(True, allCliRet, errMsg)

        dev = contextUtil.getDevObj(context)
        upgPatchPkgVer = dev.getUpgPatchPkgVer()
        logger.logInfo("Upgrade patch package version = %s" % (upgPatchPkgVer))
        allCliRet += "Patch package version:%s\n" %upgPatchPkgVer

        upgPatchPkgVRCVer = baseUtil.getVRCVersion(upgPatchPkgVer)
        eccRiskPatchVRCVer = baseUtil.getVRCVersion(ECC_RISK_PATCH_PKG_VER)
        if upgPatchPkgVRCVer == eccRiskPatchVRCVer and upgPatchPkgVer >= ECC_RISK_PATCH_PKG_VER:
            return common.getUpgEvaluationRs(True, allCliRet, errMsg)

        errMsg = common.getMsg(lang, "ecc.risk.nopass", (curDeviceVersion, destVersion))
        return common.getUpgEvaluationRs(False, allCliRet, errMsg)

    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(lang, "query.result.abnormal"))
