# -*- coding: UTF-8 -*-
from business.common import common, resource
from frameone.util import contextUtil
from cbb.business.checkitems.check_item_daemon_process import (
    CheckDeamonProcess,
)

from cbb.frame.cli.execute_on_all_controllers import ExeOnAllCtrlContext
from cbb.frame.cli.execute_on_all_controllers import ResultType
from com.huawei.ism.tool.obase.exception import ToolException


def execute(context):

    """
    系统daemon进程检查
    步骤1 以admin用户登录设备；
    步骤2 执行命令：change user_mode current_mode user_mode=developer，
    进入developer模式；
    步骤3 执行命令：minisystem，进入minisystem模式；
    步骤4 执行命令：ps -C daemon，查询daemon进程的PID；
    步骤5 登录当前设备所有控制器重复执行步骤2~步骤4。
    否则检查结果为不通过。
    若任意控制器中步骤4回显不包含daemon字样，则检查结果为不通过，否则检查通过。
    :param context:
    :return:
    """
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    exe_context = ExeOnAllCtrlContext(context)
    lang = contextUtil.getLang(context)
    cli = contextUtil.getCLI(context)
    logger.logInfo("CheckDeamonProcess start---")
    check_deamonprocess = CheckDeamonProcess(
        exe_context, context.get("logger"), lang, cli
    )
    try:
        result_type, err_mag = check_deamonprocess.execute_check()
        err_mag = err_mag if err_mag not in resource.MESSAGES_DICT else common.getMsg(lang, err_mag)
        logger.logInfo("CheckDeamonProcess end---")
        return (
            get_restlt(result_type),
            "".join(check_deamonprocess.all_ret_list),
            err_mag,
        )
    except (ToolException, Exception) as exception:
        logger.logError(str(exception))
        if "PwdCLIOverrunException" in str(exception):
            check_deamonprocess.all_ret_list.append(exception.getErrorId())
            return (
                ResultStatus.NOCHECK,
                "".join(check_deamonprocess.all_ret_list),
                common.getMsg(lang, "login.clis.overrun.info"),
            )
        return (
            ResultStatus.NOCHECK,
            "".join(check_deamonprocess.all_ret_list),
            common.getMsg(lang, "query.result.abnormal"),
        )


def get_restlt(result_type):
    trans_dict = {
        ResultType.SUCCESS: ResultStatus.PASS,
        ResultType.FAILED: ResultStatus.NOTPASS,
        ResultType.NOT_FINISHED: ResultStatus.NOCHECK,
        ResultType.NOT_SUPPORT: ResultStatus.NO_SUPPORT,
        ResultType.WARNING: ResultStatus.WARNING,
    }
    return trans_dict.get(result_type)


class ResultStatus:
    PASS = "0"
    NOTPASS = "1"
    NOCHECK = "2"
    NO_SUPPORT = "3"
    WARNING = "4"
