# -*- coding: UTF-8 -*-

from frameone.util import contextUtil
from frameone.util import baseUtil
from frameone.base.constants import CheckStatus
from cbb.frame.cli.cliUtil import get_system_version_with_ret
from cbb.business.operate.checkitems.check_required_hot_patch import get_patch_ver_digital

# 升级前补丁检查当前版本及对应补丁
DEV_VERSION_PATCH_DICT = {
    "V500R007C60SPC100": {"need_patch": "V500R007C60SPH115"},
    "V500R007C60SPC300": {"need_patch": "V500R007C60SPH335"},
    "V500R007C71SPC100": {"need_patch": "V500R007C71SPH152"},
    "V500R007C73SPC100": {"need_patch": "V500R007C71SPH123"},
    "6.0.0": {"need_patch": "6.0.0.SPH11"},
    "6.0.1": {"need_patch": "6.0.1.SPH35"},
    "6.1.0": {"need_patch": "6.1.0.SPH36"},
    "6.1.RC3": {"need_patch": "6.1.RC3.SPH1"},
    "6.1.2": {"need_patch": "6.1.2.SPH66"},
    "6.1.3": {"need_patch": "6.1.3.SPH31"},
    "6.1.5": {"need_patch": "6.1.5.SPH33",
              "extend": {
                  "patch_version": "6.1.5.SPH1",
                  "product_models": ("OceanStor Dorado 2000", "OceanStor 2910",)
              }
              },
    "6.1.6": {"need_patch": "6.1.6.SPH18",
              "extend": {
                  "patch_version": "--",
                  "product_models": ("OceanStor 2910",)
              }},
    "6.1.7": {"need_patch": "6.1.7.SPH6",
              "extend": {
                  "patch_version": "--",
                  "product_models": ("OceanStor 2910",)
              }},
}


def execute(context):
    return HotpatchBeforeUpgrade(context).check()


class HotpatchBeforeUpgrade():
    def __init__(self, context):
        self.context = context
        self.logger = contextUtil.getLogger(context)
        self.cli = contextUtil.getCLI(context)
        self.lang = contextUtil.getLang(context)
        self.dev = context.get("dev")
        self.dev_type = str(self.dev.getDeviceType())
        self.all_ret = ""
        self.err_msg = ''

    def check(self):
        try:
            self.logger.info("begin to check hot patch.")
            flag, software_version, patch_version, self.all_ret = get_system_version_with_ret(self.cli, self.lang)
            self.logger.info(
                "hotpatch_before_upgrade software_version:{},patch_version:{}".format(software_version, patch_version))
            if not flag:
                self.err_msg = baseUtil.getPyResource(self.lang, "query.result.abnormal")
                self.logger.error("Version query result abnormal.")
                return CheckStatus.NOCHECK, self.all_ret, self.err_msg
            patch_num = get_patch_ver_digital(patch_version)
            self.logger.info("hotpatch_before_upgrade patch_num:{}".format(patch_num))
            if not DEV_VERSION_PATCH_DICT.get(software_version):
                return CheckStatus.PASS, self.all_ret, ""

            if patch_version is "":
                patch_version = "--"

            need_patch_version = DEV_VERSION_PATCH_DICT.get(software_version).get("need_patch")
            extend = DEV_VERSION_PATCH_DICT.get(software_version).get("extend")

            if extend and self.dev_type in extend.get("product_models"):
                need_patch_version = extend.get("patch_version")
            self.logger.info(
                "hot_patch_before_upgrade extend:{},need_patch_version:{}".format(extend, need_patch_version))

            if patch_num < get_patch_ver_digital(need_patch_version):
                self.logger.info("patch version lower than the recommended version")
                err_msg = baseUtil.getMsg(self.lang, "check.hotpatch.not.pass", need_patch_version)
                return CheckStatus.NOTPASS, self.all_ret, err_msg

            return CheckStatus.PASS, self.all_ret, ""
        except Exception as e:
            self.logger.error("HotpatchBeforeUpgrade exception.{}".format(str(e)))
            return CheckStatus.NOCHECK, self.all_ret, baseUtil.getMsg(self.lang, "query.result.abnormal")
