# -*- coding: UTF-8 -*-

import traceback
from frameone.util import contextUtil, baseUtil
from frameone.base.constants import CheckStatus
from frameone.cli import cliUtil


destVersionNeedCheck = ["V300R006C50", "V300R006C50SPC100", "V500R007C30", "V500R007C30SPC100"]

'''
业务IP升级后可用性检查
'''
def execute(dataDict):
    return IpUseableCheck(dataDict).check()


class IpUseableCheck():
    def __init__(self, context):
        self.context = context
        self.logger = contextUtil.getLogger(context)
        self.lang = contextUtil.getLang(context)
        self.commonMsg = baseUtil.getMsg(self.lang, "query.result.abnormal")
        self.originInfos = ""

    def check(self):
        try:
            # 升级目标版本不为指定版本，则检查通过
            destVersion = contextUtil.getTargetVersion(self.context)
            if destVersion not in destVersionNeedCheck:
                return CheckStatus.PASS, self.originInfos, ""

            # 查询物理端口和逻辑端口的IP信息
            cmdPhyIp = "show port general logic_type=Host_Port physical_type=ETH"
            cmdLogIp = "show logical_port general"
            cmdList = [cmdPhyIp, cmdLogIp]
            ipSpecList = []
            for cmd in cmdList:
                flag, ipSpec= self.checkIpAdress(cmd)
                if flag is not True:
                    return CheckStatus.NOCHECK, self.originInfos, self.commonMsg
                ipSpecList.extend(ipSpec)
            # 存在指定网段的IP地址，则检查不通过
            if len(ipSpecList) != 0:
                errMsg = baseUtil.getMsg(self.lang, "ipUseableCheck.nopass", destVersion)
                return CheckStatus.NOTPASS, self.originInfos, errMsg

            return CheckStatus.PASS, self.originInfos, ""
        except:
            self.logger.error('exception:%s.' % traceback.format_exc())
            return CheckStatus.NOCHECK, self.originInfos, self.commonMsg

    def checkIpAdress(self, cmd):
        # 获取172.16.x.x和10.253.x.x网段的IPV4地址
        try:
            ipSpec = []
            self.cli = contextUtil.getCLI(self.context)
            excuteRet = cliUtil.excuteCmdInCliMode4Privilege(self.cli, cmd, True, self.lang)
            self.originInfos += excuteRet[1]
            # 如果设备不支持此查询命令,则跳过该命令步骤继续检查
            if excuteRet[0] == cliUtil.RESULT_NOSUPPORT:
                self.logger.info("The device does not support this command.")
                return True, ipSpec
            elif excuteRet[0] is not True:
                self.logger.info("Cannot get host port info")
                return False, ipSpec

            cliRetList = cliUtil.getHorizontalCliRet(excuteRet[1])
            for retDict in cliRetList:
                ipV4Adress = retDict.get("IPv4 Address", "")
                if ipV4Adress.startswith("172.16.") \
                        or ipV4Adress.startswith("10.253."):
                    ipSpec.append(ipV4Adress)
            return True, ipSpec
        
        except:
            return False, ipSpec