# -*- coding: UTF-8 -*-
import traceback

from frameone.util import contextUtil, baseUtil
from business.common.config import NAS_REDUNTANT_LINK_VER
from frameone.cli import cliUtil
from frameone.base.constants import CheckStatus, CheckResult
import traceback

def execute(dataDict):
    logger = contextUtil.getLogger(dataDict)
    lang = contextUtil.getLang(dataDict)

    # 检查是否在检查版本范围内V300R003C10及之后的版本
    currentVersion = contextUtil.getCurVersion(dataDict)
    devType = contextUtil.getDevType(dataDict)
    logger.info("currentVersion is %s" % (currentVersion))
    if currentVersion < NAS_REDUNTANT_LINK_VER["minCurrentVersion"] and not baseUtil.isDoradoNasDev(devType):
        logger.info("The device not need check nas redundant link.")
        return CheckStatus.NO_SUPPORT, "", ""

    issupportnas = contextUtil.getItem(dataDict, 'supportnas')
    logger.info("[nasRedundantLink]get the supportnas value is:%s" % issupportnas)
    if issupportnas is None or issupportnas == "NOCHECK":
        logger.info("nasRedundantLink check exception:cli_service_protocal.py exception.")
        commonMsg = baseUtil.getMsg(lang, "query.result.abnormal")
        return CheckStatus.NOCHECK, "", commonMsg
    if issupportnas == False:
        return CheckStatus.PASS, "", ""

    checkResult = RedundantLinkCheck(dataDict).execute()
    return checkResult.toScriptResult()


class RedundantLinkCheck():
    def __init__(self, context):
        self.logger = contextUtil.getLogger(context)
        self.lang = contextUtil.getLang(context)
        self.context = context
        self.originInfos = []
        self.commonMsg = baseUtil.getMsg(self.lang, "query.result.abnormal")

    def execute(self):
        self.cli = contextUtil.getCLI(self.context)
        try:
            failoverGroupInfoRet = self.queryfailoverGroupInfo()
            if failoverGroupInfoRet[0] == False:
                return CheckResult(CheckStatus.NOCHECK, self.originInfos, failoverGroupInfoRet[2])
            if len(failoverGroupInfoRet[1]) == 0:
                return CheckResult(CheckStatus.PASS, self.originInfos, "")
            notRedundantLogicPort = {}
            self.bondPort = {} #整个系统的show bond_port命令的Link up的端口
            failoverGroupInfoList = failoverGroupInfoRet[1]
            groupIdRedundantDict = {} #保存相同的failoverGroupID的冗余状态，避免同一个ID重复查询端口信息
            for failoverGroupInfo in failoverGroupInfoList:
                self.allPortList4OneGroup = []
                logicalPortName = failoverGroupInfo.get("Logical Port Name")
                supportProtocal = failoverGroupInfo.get("Support Protocol")
                failoverGroupId = failoverGroupInfo.get("Failover Group ID")
                if "NFS" not in supportProtocal and "CIFS" not in supportProtocal:
                    self.logger.info("The logical port(%s) is not support nas." % logicalPortName)
                    continue
                if failoverGroupId == "":
                    self.logger.info("The logical port(%s) failoverGroupId is null." % logicalPortName)
                    continue
                if groupIdRedundantDict.has_key(failoverGroupId):
                    isRedundant = groupIdRedundantDict.get(failoverGroupId)
                    if isRedundant:
                        self.logger.info("The logical port(%s) is redundant." % logicalPortName)
                    else:
                        notRedundantLogicPort[logicalPortName] = failoverGroupId
                        self.logger.info("The logical port(%s) is not redundant." % logicalPortName)
                    continue
                #查询ETH端口是否冗余
                portListRet = self.queryETHPortByFailoverGroupId(failoverGroupId)
                if portListRet[0] == False:
                    return CheckResult(CheckStatus.NOCHECK, self.originInfos, portListRet[2])
                isRedundant = self.checkRedundantPort(self.allPortList4OneGroup)
                groupIdRedundantDict[failoverGroupId] = isRedundant
                if isRedundant == True:
                    self.logger.info("The logical port(%s) is redundant." %logicalPortName)
                    continue

                #若ETH不冗余，继续检查bond_port端口
                portListRet = self.queryBondPort4FailoverGroup(failoverGroupId)
                if portListRet[0] == False:
                    return CheckResult(CheckStatus.NOCHECK, self.originInfos, portListRet[2])
                isRedundant = self.checkRedundantPort(self.allPortList4OneGroup)
                groupIdRedundantDict[failoverGroupId] = isRedundant
                if isRedundant == True:
                    self.logger.info("The logical port(%s) is redundant." % logicalPortName)
                    continue

                # 若ETH+bond_port不冗余，继续检查Vlan下面的bond_port端口
                portListRet = self.queryVlanBondPort(failoverGroupId)
                if portListRet[0] == False:
                    return CheckResult(CheckStatus.NOCHECK, self.originInfos, portListRet[2])
                isRedundant = self.checkRedundantPort(self.allPortList4OneGroup)
                groupIdRedundantDict[failoverGroupId] = isRedundant
                if isRedundant == True:
                    self.logger.info("The logical port(%s) is redundant." % logicalPortName)
                else:
                    notRedundantLogicPort[logicalPortName] = failoverGroupId
                    self.logger.info("The logical port(%s) is not redundant." % logicalPortName)

            if notRedundantLogicPort:
                noRedundantMsg = ""
                for logicPort,failoverGroup in notRedundantLogicPort.items():
                    noRedundantMsg += baseUtil.getMsg(self.lang, "nasRedundantLink.logicport", (logicPort,failoverGroup))
                errMsg = baseUtil.getMsg(self.lang, "nasRedundantLink.nopass", noRedundantMsg)
                return CheckResult(CheckStatus.NOTPASS, self.originInfos, errMsg)
            return CheckResult(CheckStatus.PASS, self.originInfos, "")
        except:
            self.logger.info("nasRedundantLink check exception[%s]" % traceback.format_exc())
            return CheckStatus.NOCHECK, self.originInfos, self.commonMsg

    def queryfailoverGroupInfo(self):
        '''查询漂移组信息'''
        cmd = "show logical_port general |filterColumn include columnList=Logical\sPort\sName,Failover\sGroup\sID,Support\sProtocol"
        checkRet = cliUtil.excuteCmdInDeveloperMode(self.cli, cmd, True, self.lang)
        self.originInfos.append(checkRet[1])
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return (False, "", self.commonMsg)
        if checkRet[0] != True:
            return (False, "", self.commonMsg)
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return (True, [], self.commonMsg)

        logicPortGroupInfoList = cliUtil.getHorizontalCliRet(checkRet[1])
        if len(logicPortGroupInfoList) == 0:
            return (False, "", self.commonMsg)

        return (True, logicPortGroupInfoList, "")

    def queryETHPortByFailoverGroupId(self, failoverGroupId):
        '''查询漂移组内所有的ETH物理端口'''
        cmd = "show failover_group member failover_group_id=%s type=eth_port" %failoverGroupId
        checkRet = cliUtil.excuteCmdInDeveloperMode(self.cli, cmd, True, self.lang)
        self.originInfos.append(checkRet[1])
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return (False, "", self.commonMsg)
        if checkRet[0] != True:
            return (False, "", self.commonMsg)
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return (True, "", "")
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        for line in cliRetLinesList:
            runningStatus = line.get("Running Status")
            if runningStatus == "Link Up":
                portId = line.get("ID")
                self.allPortList4OneGroup.append(portId)
        return (True, "", "")

    def queryBondPort4FailoverGroup(self, failoverGroupId):
        # 若ETH_port不冗余，继续检查Bond_port
        cmd = "show failover_group member failover_group_id=%s type=bond_port" % failoverGroupId
        checkRet = cliUtil.excuteCmdInDeveloperMode(self.cli, cmd, True, self.lang)
        self.originInfos.append(checkRet[1])
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return (False, "", self.commonMsg)
        if checkRet[0] != True:
            return (False, "", self.commonMsg)
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return (True,  "", "")
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        for line in cliRetLinesList:
            runningStatus = line.get("Running Status")
            if runningStatus == "Link Up":
                bondPortIdStr = line.get("Port ID List")
                bondPortIdList = bondPortIdStr.split(",")
                self.allPortList4OneGroup.extend(bondPortIdList)
        return (True, "", "")

    def queryVlanBondPort(self, failoverGroupId):
        # 若ETH_port和bond_port不冗余，继续检查vlan下面的绑定口
        cmd = "show failover_group member failover_group_id=%s type=vlan" % failoverGroupId
        checkRet = cliUtil.excuteCmdInDeveloperMode(self.cli, cmd, True, self.lang)
        self.originInfos.append(checkRet[1])
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return (False,  "", self.commonMsg)
        if checkRet[0] != True:
            return (False,  "", self.commonMsg)
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return (True,  "", "")
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        bondPortNameList = []
        for line in cliRetLinesList:
            runningStatus = line.get("Running Status")
            if runningStatus == "Link Up":
                bondPortName = line.get("Port ID")
                portType = line.get("Port Type")
                if portType == "Bond":
                    bondPortNameList.append(bondPortName)
                else:
                    self.allPortList4OneGroup.append(bondPortName)
        if len(bondPortNameList) == 0:
            self.logger.info("The failover(%s) has not vlan." % failoverGroupId)
            return (True, "", "")
        #若已经查询过show bond_port,不再重复执行
        if len(self.bondPort) == 0:
            queryRet = self.queryAllBondPort()
            if queryRet[0] == False:
                return (False,  "", queryRet[2])
        for bondPortName in bondPortNameList:
            bondPortIdList = self.bondPort.get(bondPortName, None)
            if bondPortIdList:
                self.allPortList4OneGroup.extend(bondPortIdList)

        return (True, "", "")

    def queryAllBondPort(self):
        #查询VLAN下面的所有绑定口
        cmd = "show bond_port"
        checkRet = cliUtil.excuteCmdInDeveloperMode(self.cli, cmd, True, self.lang)
        self.originInfos.append(checkRet[1])
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return (False, "", self.commonMsg)
        if checkRet[0] != True:
            return (False, "", self.commonMsg)
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return (True, "", "")
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        for line in cliRetLinesList:
            runningStatus = line.get("Running Status")
            if runningStatus == "Link Up":
                name = line.get("Name")
                portIdListStr = line.get("Port ID List")
                self.bondPort[name] = portIdListStr.split(",")
        return (True, "", "")

    def checkRedundantPort(self, portIdList):
        '''
        检查端口是否 A/B 平面冗余;区分端口所属平面的方法：
        物理端口ID为CTEx.A.XX或CTEx.C.XX,或者CTEx.Rx.IOMx.xx格式的，为A平面;
        物理端口ID为CTEx.B.XX或CTEx.D.XX,或者CTEx.Lx.IOMx.xx格式的，为B平面
        '''
        ctrlIds = []
        for portId in portIdList:
            ctrlId = portId.split(".")[1][0]
            ctrlIds.append(ctrlId)

        CTRL_A_PLAN = ["A", "C", "R"]
        CTRL_B_PLAN = ["B", "D", "L"]
        ctrlIds = map(lambda x: x[-1].upper(), ctrlIds)
        alist = list(set(ctrlIds).intersection(set(CTRL_A_PLAN)))
        blist = list(set(ctrlIds).intersection(set(CTRL_B_PLAN)))
        return len(alist) != 0 and len(blist) != 0

