# -*- coding: UTF-8 -*-
import traceback

from business.common import common
from frameone.util import contextUtil
from frameone.cli import cliUtil
from cbb.business.checkitems.nic_bond_mode_check import (
    CheckNicBondMode,
)
from cbb.frame.base import baseUtil
from cbb.frame.base.exception import UnCheckException
import com.huawei.ism.tool.obase.entity.EntityUtils as EntityUtils


def execute(context):
    """
    高端环境绑定端口检查
    :param context:
    :return:
    """
    cli = contextUtil.getSSH(context)
    lang = contextUtil.getLang(context)
    logger = contextUtil.getLogger(context)
    env = ""
    dev_node = EntityUtils.toOldDev(context.get('dev'))
    product_model = str(dev_node.getDeviceType())
    logger.info("product_model:{}.".format(product_model))
    if baseUtil.is_micro_dev(product_model) or baseUtil.is_computing_dev(product_model):
        logger.info("compute or micro dev is not support.")
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, "", "")

    nic_bond_mode_check_object = CheckNicBondMode(cli, lang, env, logger)
    try:
        error_message = ""
        flag = nic_bond_mode_check_object.execute_check()
        if not flag:
            error_message = common.getMsg(
                lang, "nic.bond.mode.sph6.error_message"
            )
        return common.getUpgEvaluationRs(
            flag,
            "\n".join(nic_bond_mode_check_object.all_ret_list),
            error_message,
        )

    except UnCheckException as e:
        return common.getUpgEvaluationRs(
            cliUtil.RESULT_NOCHECK,
            "\n".join(nic_bond_mode_check_object.all_ret_list),
            e.errorMsg,
        )
    except Exception:
        logger.logError(str(traceback.format_exc()))
        return common.getUpgEvaluationRs(
            cliUtil.RESULT_NOCHECK,
            "\n".join(nic_bond_mode_check_object.all_ret_list),
            common.getMsg(lang, "query.result.abnormal"),
        )
