# -*- coding: UTF-8 -*-
from business.common import common
from frameone.util import contextUtil
from frameone.cli import cliUtil

TIME_ZONE_CANADA = "Canada/East-Saskatchewan"
TIME_ZONE_ISRAEL = "Israel"
TIME_ZONE_ELALIUN = "El_Aliun"


def execute(context):
    """升级前设置的时区如果在升级后新版本不支持，则会以UTC+8时区运行，产生时区跳变，
        影响部分增值业务。

    :param context:
    :return:
    """
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    errMsg = ""
    allCliRet = ""

    try:
        # 检查升级路径，获取需要检查的时区列表
        time_zone_list = list(get_check_time_zone(context, logger))
        if not time_zone_list:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT,
                                             allCliRet, errMsg)

        cli = contextUtil.getCLI(context)
        # 获取回显中"Time Zone Name"的IP数量
        cmd = "show system timezone"
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        # 判断是否含异常场景
        if flag is not True:
            logger.logInfo('execute show system timezone error.')
            errMsg = common.getMsg(lang, "cannot.get.timezone.info")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet,
                                             errMsg)
        if cliUtil.queryResultWithNoRecord(cliRet):
            errMsg = common.getMsg(lang, "cannot.get.timezone.info")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet,
                                             errMsg)
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.timezone.info")
            logger.logNoPass("Cannot get information about disk domain")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet,
                                             errMsg)
        for line in cliRetLinesList:
            timeZoneName = line.get("Time Zone Name", "")
            if [time_zone for time_zone in time_zone_list if
                    time_zone in timeZoneName]:
                errMsg = common.getMsg(lang, "timezone.check.nopass",
                                       timeZoneName)
                return common.getUpgEvaluationRs(False, cliRet, errMsg)

        return common.getUpgEvaluationRs(True, cliRet, errMsg)

    except Exception as exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(
            cliUtil.RESULT_NOCHECK, allCliRet,
            common.getMsg(lang, "query.result.abnormal"))


def get_check_time_zone(context, logger):
    """根据升级路径，获取需要检查的时区集合

    :param context: 上下文
    :param logger: 日志对象
    :return:
    """
    curVersion = contextUtil.getCurVersion(context)
    destVersion = contextUtil.getTargetVersion(context)
    logger.logInfo("current Device Version = %s, dest version=%s " % (
        curVersion, destVersion))
    time_zone_set = set()
    if "V3" in curVersion:
        if curVersion < "V300R006C61" <= destVersion:
            time_zone_set.add(TIME_ZONE_ISRAEL)
            time_zone_set.add(TIME_ZONE_ELALIUN)
        if curVersion < "V300R006C50" <= destVersion:
            time_zone_set.add(TIME_ZONE_CANADA)

    elif "Kunpeng" in curVersion:
        if curVersion < "V500R007C70" <= destVersion:
            time_zone_set.add(TIME_ZONE_ISRAEL)
            time_zone_set.add(TIME_ZONE_ELALIUN)

    elif "V5" in curVersion:
        if curVersion < "V500R007C61" <= destVersion:
            time_zone_set.add(TIME_ZONE_ISRAEL)
            time_zone_set.add(TIME_ZONE_ELALIUN)
        if curVersion < "V500R007C30" <= destVersion:
            time_zone_set.add(TIME_ZONE_CANADA)

    return time_zone_set
