# -*- coding: UTF-8 -*-

from business.common import common
from cbb.business.checkitems.cli_cpu_kv_usage_check import KvUsageChecker
from cbb.frame.cli.execute_on_all_controllers import ResultType
from frameone.base import config
from frameone.cli import cliUtil


def execute(data_dict):
    """
    iod cpuusage show 10
    CPU partition [10] IOD_KV Usage:0
    admin:/diagnose>
    """

    product_version = str(data_dict.get('dev').getProductVersion())
    device_type = str(data_dict.get('dev').getDeviceType())
    # 版本范围：Dorado V3R1C01SPC100 + 未安装补丁;Dorado V3R1C01SPC100 + SPH101;
    # Dorado V3R1C01SPC100 + SPH102;Dorado V3R1C01SPC100 + SPH103
    if not product_version.startswith(
            "V300R001C01") or device_type not in config.DORADO_DEVS:
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, '', '')

    checker = KvUsageChecker(data_dict)
    flag, device_res, error_msg = checker.execute_check()
    return common.getUpgEvaluationRs(flag, device_res, error_msg)
