# coding:utf-8
from business.service.frontlinkcheck import checkByPortLink, checkByHostLink
from frameone.util import contextUtil, baseUtil
from business.common import common

ITEM_ID = "rest_frontLinkCheck"

def execute(context):
    try:
        logger = contextUtil.getLogger(context)
        devVersion = contextUtil.getCurVersion(context)
        devType = contextUtil.getDevType(context)

        context["checkState"] = common.PROCESS_STATE_CHECKING
        common.threadUp(context, ITEM_ID, 10, 35)
        if baseUtil.isDoradoDev(devType):
            logger.info("run checkByPortLink")
            return checkByPortLink.execute(context)

        # V1R1C30/V2R2C30/V3R1C20之前的版本走主机链路检查方案
        if ("V1" in devVersion and devVersion < "V100R001C30") \
                or ("V2" in devVersion and devVersion < "V200R002C30") \
                or ("V3" in devVersion and (devVersion < "V300R001C20" or "V300R002C10" in devVersion)):
            logger.info("run checkByHostLink")
            return checkByHostLink.execute(context)

        # V5R7C20及之后的版本走主机链路的方案
        if ("V3" in devVersion and devVersion >= "V300R006C30") \
                or ("V5" in devVersion and devVersion >= "V500R007C20"):
            logger.info("run checkByPortLink")
            return checkByPortLink.execute(context)


        # V5R7C20之前的版本走端口反查的方案
        logger.info("run checkByPortLink")
        return checkByPortLink.execute(context)
    finally:
        try:
            common.finishProcess(context, ITEM_ID)
        finally:
            common.setProgress(context, common.PROGRESS_NUM_MAX, ITEM_ID)






