# -*- coding: UTF-8 -*-

import traceback
from frameone.util import contextUtil, baseUtil
from frameone.base.constants import CheckStatus, CheckResult
from frameone.adapter.resourceService import ResrouceFactory
from com.huawei.ism.exception import IsmException

RISK_BOUNDARY_VERSION = "V300R002C00"
NO_LICENSE_ERROR_CODE = "1077949004"

def execute(dataDict):
    checkResult = IsExistUncompletedCloudBackUpTask(dataDict).check()
    return checkResult.toScriptResult()


class IsExistUncompletedCloudBackUpTask():

    def __init__(self, context):
        self.logger = contextUtil.getLogger(context)
        self.lang = contextUtil.getLang(context)
        self.current_version = contextUtil.getCurVersion(context)
        self.context = context
        self.origin_infos = []
        self.common_msg = baseUtil.getMsg(self.lang, "query.result.abnormal")
        #uri只做原始信息回显使用，下发命令的uri在restService中，请保持同步修改。
        self.uri = "cloudbackup_task?filter=taskType::10%20and%20status::1%20or%20taskType::10%20and%20status::2&range=[0-100]"

    def check(self):
        try:
            # 离线版本检查
            self.logger.info("currentVersion is %s" % (self.current_version))
            if self.current_version < RISK_BOUNDARY_VERSION:
                return CheckResult(CheckStatus.NO_SUPPORT, self.origin_infos)

            self.resrouce_factory = ResrouceFactory(self.context)
            cloud_backup_rec = self.resrouce_factory.executeInterface("get_undone_cloud_backup_task")
            self.origin_infos.append("Rest Uri:%s\nResponse:%s"%(self.uri, cloud_backup_rec))
            #存在未完成的恢复任务检查不通过
            if cloud_backup_rec:
                err_msg = baseUtil.getMsg(self.lang, "CloudBackup.Task.status.notpass")
                return CheckResult(CheckStatus.NOTPASS, self.origin_infos, err_msg)
            return CheckResult(CheckStatus.PASS, self.origin_infos, "")

        except IsmException as msg:
            error_id = msg.getErrorId()
            self.origin_infos.append("Rest Uri:%s\nCode:%s" %(self.uri, error_id))
            self.logger.error("cloudbackupTaskStatus check IsmException error id is %s" % error_id)
            #当license不存在时，检查通过
            if error_id and str(error_id) == NO_LICENSE_ERROR_CODE:
                self.logger.error("rssStatusSupportOnline check excption [%s]" % msg.getErrorId())
                return CheckResult(CheckStatus.PASS, self.origin_infos, "")
            else:
                self.logger.error("rssStatusSupportOnline check excption [%s]" % traceback.format_exc())
                return CheckResult(CheckStatus.NOCHECK, self.origin_infos, self.common_msg)
        except:
            self.logger.error("rssStatusSupportOnline check excption [%s]" % traceback.format_exc())
            return CheckResult(CheckStatus.NOCHECK, self.origin_infos, self.common_msg)