# -*- coding: UTF-8 -*-

import com.huawei.ism.tool.obase.entity.EntityUtils as EntityUtils

from business.common import common
from frameone.util import contextUtil
from business.checkitems.container_base_check import ContainerCheck


def execute(context):
    """
    数据保护告警信息检查
    """
    logger = contextUtil.getLogger(context)
    lang = contextUtil.getLang(context)
    logger.info("alarm info check start.")
    dev_node = EntityUtils.toOldDev(context.get('dev'))
    check_url_list = ["inspections/alarms?lang={}".format(lang)]

    item_check = ContainerCheck(dev_node, check_url_list, lang, logger)
    flag, msg = item_check.execute_check()
    ret = deal_unicode("\n".join(item_check.all_cli_ret))
    return common.getUpgEvaluationRs(flag, ret, msg)


def deal_unicode(ret):
    try:
        return unicode(ret).decode("unicode-escape")
    except (UnicodeEncodeError, Exception):
        return ret
