# -*- coding: UTF-8 -*-

import com.huawei.ism.tool.obase.entity.EntityUtils as EntityUtils


from business.common import common
from business.checkitems.container_base_check import ContainerCheck
from frameone.util import contextUtil

CHECK_URL_LIST = ["infra/inspect/config/status"]


def execute(context):
    """
    二级存储关键配置状态
    """
    logger = contextUtil.getLogger(context)
    lang = contextUtil.getLang(context)
    dev_node = EntityUtils.toOldDev(context.get('dev'))
    item_check = ContainerCheck(dev_node, CHECK_URL_LIST, lang, logger)
    flag, msg = item_check.execute_check()
    return common.getUpgEvaluationRs(
        flag, "\n".join(item_check.all_cli_ret), msg)
