# -*- coding: UTF-8 -*-

import com.huawei.ism.tool.obase.entity.EntityUtils as EntityUtils

from business.common import common
from business.checkitems.container_base_check import ContainerCheck
from frameone.util import contextUtil

CHECK_URL_LIST = ["infra/inspect/resource/status"]


def execute(context):
    """
    二级存储检查资源状态：CPU/内存/磁盘信息
    """
    lang = contextUtil.getLang(context)
    logger = contextUtil.getLogger(context)
    dev_node = EntityUtils.toOldDev(context.get('dev'))
    item_check = ContainerCheck(dev_node, CHECK_URL_LIST, lang, logger)
    flag, msg = item_check.execute_check()
    return common.getUpgEvaluationRs(
        flag, "\n".join(item_check.all_cli_ret), msg)
