# -*- coding: UTF-8 -*-

from business.checkitems.container_base_check import ContainerCheck
from business.common import common
from frameone.util import contextUtil

import com.huawei.ism.tool.obase.entity.EntityUtils as EntityUtils

CHECK_URL_LIST = ["infra/inspect/service/status"]

RISK_MODE = "OceanProtect A8000"


def execute(context):
    """
    二级存储所有pod和容器运行状态
    """
    lang = contextUtil.getLang(context)
    logger = contextUtil.getLogger(context)
    dev_node = EntityUtils.toOldDev(context.get('dev'))
    product_model = str(dev_node.getDeviceType())
    if RISK_MODE not in product_model:
        return common.getUpgEvaluationRs(
            True, "Product Mode:{}".format(product_model), '')
    item_check = ContainerCheck(dev_node, CHECK_URL_LIST, lang, logger)
    flag, msg = item_check.execute_check()
    return common.getUpgEvaluationRs(
        flag, "\n".join(item_check.all_cli_ret), msg)
