# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus
from business.common import common
import time
from business.common import checkUtils
from frameone.util import baseUtil
suffix1 = "V200R002C00"
suffix2 = "V200R002C00B020"

CMD_DEFAULT_TIMEOUT = 60

cliRet = ''
def execute(dataDict):
    
    dev = dataDict.get("dev")
    logger = dataDict.get("logger")
    devVersion = dev.getProductVersion()
    logger.info("Device link check devVersion:" + devVersion)
    if devVersion.endswith(suffix1) or devVersion.endswith(suffix2):
        logger.info("Device link check return true!")
        return (0, "","")
    
    dataDict['checkType'] = "PRECHECK"
    
    ##执行升级前检查
    itemMsg = preCheck(dataDict)

    return common.getUpgEvaluationRs(itemMsg["status"], cliRet, itemMsg["suggession"])

"""
    查询升级检查项，并更新界面
"""
def updateUi(recs, dataDict):
    recNum = recs.size()
    lang = dataDict.get('lang')
    logger = dataDict.get("logger")
    itemMsg = {}
    for index in range(0, recNum):
        rec = recs.get(index)
        result = rec.getParamStrValue(1)
        logger.info("result:" + result)
        if result == "True":
            #执行成功
            itemState = 3
            errorKey = "DevLinkCheck.pass"
        elif result == "False":
            #执行失败
            itemState = 4
            errorKey = "DevLinkCheck.notpass"
        elif result == "TimeOut":
            #执行超时
            itemState = 4
            errorKey = "DevLinkCheck.timeout"
        else:
            #执行出错
            itemState = 4
            errorKey = "DevLinkCheck.error"
        suggession = baseUtil.getMsg(lang, errorKey)
        
        itemMsg = {
            ##检查项名称，类型String
            ## 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
            "status":itemState == 3,
            ##修复建议
            "suggession":suggession
        }
        if 0!=itemMsg["status"]:
            return itemMsg
    return itemMsg

"""
    执行升级前检查，并更新界面
"""
def preCheck(dataDict):
        recs = checkUtils.executeCheck(dataDict, "upd checkdevicelink", 2)
        return updateUi(recs, dataDict)
