# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus

import time
from business.common import checkUtils
from frameone.util import baseUtil



def execute(dataDict):
    dataDict['checkType'] = "PRECHECK"
    
    ##执行升级前检查
    return preCheck(dataDict)

"""
    查询升级检查项，并更新界面
"""
def updateUi(recs, dataDict):
    lang = dataDict.get("lang")
    logger = dataDict.get("logger")
    recNum = recs.size()
    itemMsg = {}
    for index in range(0, recNum):
        rec = recs.get(index)
        result = rec.getParamStrValue(1)
        logger.info("result:"+result)
        if result == "True":
            #有告警
            itemState = 3
            errorKey = "SysConfigurationLogCheck.pass"
        elif result =="False":
            #无告警
            itemState = 4
            errorKey = "SysConfigurationLogCheck.notpass"
        elif result =="TimeOut":
            #执行超时
            itemState = 4
            errorKey = "SysConfigurationLogCheck.timeout"
        else:
            #执行出错
            itemState = 3
            errorKey = "SysConfigurationLogCheck.pass"
        suggession = baseUtil.getMsg(lang, errorKey)
        
        itemMsg = {
            ## 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
            "status":itemState % 3,
            ##修复建议
            "suggession":suggession
        }
        if itemMsg["status"] != 0:
            return (itemMsg["status"],'',itemMsg["suggession"])
    return (itemMsg["status"],'','')

"""
    执行升级前检查，并更新界面
"""
def preCheck(dataDict):
        recs = checkUtils.executeCheck(dataDict, "sys showcfglog", 1)
        return updateUi(recs, dataDict)
