# -*- coding: UTF-8 -*-
import traceback
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Param
from business.common import common
from business.common import resource
from frameone.util import contextUtil
from frameone.util import baseUtil
from frameone.rest import restData
from com.huawei.ism.exception import IsmException
from java.lang import Exception as JException
from frameone.rest.restUtil import Tlv2Rest

from frameone.cli import cliUtil
from frameone.base.constants import CheckStatus

from com.huawei.ism.tool.protocol.tlv.exception import TLVException
GET_IS_EXIST_URGENT_ALM_CLEARED = 55847747768
TIMEOUT_ERRORCODE = 1077949001
CMDNOTEXIST_ERRORCODE = 1077949002
TRANS_DICT = {
                "FALSE":"False",
                "TRUE":"True",
                TIMEOUT_ERRORCODE:"Timeout",
                }

def execute(context):
    checker = IsUserDelUrgAlarm(context)
    return checker.execute()

class IsUserDelUrgAlarm():
    
    def __init__(self, context):
        self.lang = contextUtil.getLang(context)
        self.logger = common.getLogger(contextUtil.getLogger(context), __file__)
        self.context = context
        self.originInfos = ""
        self.errMsg = ""
    
    """升级前检查：用户是否删除严重告警
            检查方法：tlv命令下发，如果查询到返回值为False，检查通过，为True检查不通过，其它情况为异常。
    """ 

    def execute(self):
        isUseRest = False
        conn = contextUtil.getTlvObj(self.context)
        #如果TLV连接中断，尝试重连。
        if conn is None:
           isUseRest = True 
           self.logger.logInfo("[ISUserDelUrgAlarm] using Rest instead of TLV")
           conn = contextUtil.getRest(self.context)
        else:
            isTLVConnected = conn.isSocketConnected()
            self.logger.logInfo("[ISUserDelUrgAlarm] tool start TLVreconect flag is: %s" % isTLVConnected)
            if isTLVConnected is False:
                conn.reConnect()
        isPass, result = self.executeAlarmCheckTLVCmd(conn, isUseRest)
        cmd_querydelalarm = "show event status=cleared |filterRow column=Level predict=match value=Major " \
                            "logicOp=or column=Level predict=match value=Critical"
        cliCon = contextUtil.getCLI(self.context)
        status, cliRet, _ = cliUtil.excuteCmdInCliMode(cliCon, cmd_querydelalarm, True, self.lang)
        self.originInfos += "\n" + cliRet
        # if command does not exist
        if result == CMDNOTEXIST_ERRORCODE:
            self.logger.logInfo("[ISUserDelUrgAlarm] command not exist.")
            return common.getUpgEvaluationRs(True, self.originInfos, self.errMsg)
        #Parsing result
        evalResult = ""
        try: 
            if isUseRest:
                evalResult = Tlv2Rest.getRecordValue(result, restData.Upgrade.UrgentAlmCleared.URGENT_ALM_RESULT)
            else:  
                evalResult = result.getParamStrValue(71)
            
        except BaseException, excp:
            
            self.logger.logInfo("[ISUserDelUrgAlarm] parsing TLV returnValue exception!" + str(excp))
            return common.getUpgEvaluationRs(CheckStatus.NOCHECK, self.originInfos, self.errMsg)
        # true is False ; false is True
        
        if evalResult == TIMEOUT_ERRORCODE:
            self.errMsg = common.getMsg(self.lang, "check.result.timeout")
            return common.getUpgEvaluationRs(CheckStatus.NOCHECK, self.originInfos, self.errMsg)
        elif evalResult.lower() == "true" :
            self.errMsg = common.getMsg(self.lang, "check.ISUserDelUrgAlarm.notpass")
            return common.getUpgEvaluationRs(False, self.originInfos, self.errMsg)
        elif evalResult.lower() == "false":
            
            return common.getUpgEvaluationRs(True, self.originInfos, self.errMsg)
        else:
            self.errMsg = common.getMsg(self.lang, "check.anyItem.exception.common")
            return common.getUpgEvaluationRs(CheckStatus.NOCHECK, self.originInfos, self.errMsg)
         
        
    def executeAlarmCheckTLVCmd(self, conn, isUseRest):
        locationId = UnsignedInt32(65533)
        isSuc = False
        if isUseRest:
            msgParam13 = (restData.Upgrade.UrgentAlmCleared.CMO_ALARM_LOCATION, locationId)
            params = [msgParam13]
            self.originInfos += "command Code(Rest): " +\
                            str(restData.TlvCmd.GET_IS_EXIST_URGENT_ALM_CLEARED.get("cmd")) + "\n"
            try:
                recs = Tlv2Rest.execCmd(conn, restData.TlvCmd.GET_IS_EXIST_URGENT_ALM_CLEARED, params)
                recs = recs[0]
                isSuc = True
                self.originInfos += "result: " + str(recs) + "\n"     
                self.logger.logInfo("[IsUserDelUrgAlarm]recsValue=%s,type(recsValue)=%s" % (str(recs),type(recs)))
            except (TLVException, IsmException), msg:
                self.logger.logInfo("[IsUserDelUrgAlarm]ErrorCode we got using Rest Con was %s." % msg.getErrorId())
                recs = msg.getErrorId()
                self.originInfos += "result: " + str(recs) + "\n"  
            return isSuc, recs
        else:
            msgParam13 = Param(13, ParamType.UNSIGN_INT, locationId)
            params = TLVUtils.paramList(msgParam13)
            self.originInfos += "command Code(TLV): " +\
                            str(GET_IS_EXIST_URGENT_ALM_CLEARED) + "\n"
            self.logger.logInfo('[IsUserDelUrgAlarm][code:%s] [%s]' % 
                                (str(GET_IS_EXIST_URGENT_ALM_CLEARED), params))
            
            try:
                recs = conn.invoke(GET_IS_EXIST_URGENT_ALM_CLEARED, params, 60*5)
                isSuc = True
                self.originInfos += "result: " + str(recs.toString()) + "\n"
                self.logger.logInfo("[IsUserDelUrgAlarm]result=%s,type(recsValue)=%s" % (str(recs),type(recs)))
            except (TLVException, IsmException), msg:
                self.logger.logInfo("[IsUserDelUrgAlarm]exception occurred, errorID: %s." % msg.getErrorId())
                recs = msg.getErrorId()
                self.originInfos += "result: " + str(recs) + "\n"
            
            return isSuc, recs