# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus
from frameone.base.constants import  CheckResult
from business.common import checkUtils
import time
from frameone.util import baseUtil

CMD_DEFAULT_TIMEOUT = 60

def execute(dataDict):
    dataDict['checkType'] = "PRECHECK"
    
    ##执行检查
    return preCheck(dataDict)
    

"""
    查询升级检查项，并更新界面
"""
def updateUi(recs, dataDict):
    lang = dataDict.get("lang")
    logger = dataDict.get("logger")
    recNum = recs.size()
    for index in range(0, recNum):
        rec = recs.get(index)
        result = rec.getParamStrValue(1)
        logger.info("result:" + result)
        if result == "True":
            #执行成功
            itemState = 3
            errorKey = "GetPoolStatus.pass"
        elif result == "False":
            #执行失败
            itemState = 4
            errorKey = "GetPoolStatus.notpass"
        elif result == "TimeOut":
            #执行超时
            itemState = 4
            errorKey = "GetPoolStatus.timeout"
        else:
            #执行出错
            itemState = 4
            errorKey = "GetPoolStatus.error"
        suggession = baseUtil.getMsg(lang, errorKey)
        itemMsg = {
            ## 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
            "status":itemState % 3,
            ##修复建议
            "suggession":suggession
        }
        if 0 != itemMsg["status"]:
            return itemMsg["status"],'',itemMsg["suggession"]

    return itemMsg["status"],'',''
    

"""
    执行升级前检查，并更新界面
"""
def preCheck(dataDict):
        recs = checkUtils.executeCheck(dataDict, "pmgr isallpoolcanupgrade", 2)
        return updateUi(recs, dataDict)
