# -*- coding: UTF-8 -*-

import traceback

from business.common import common
from frameone.cli import cliUtil

from cbb.frame.rest import restUtil

from com.huawei.ism.exception import IsmException
from java.lang import Exception as JException


class ContainerCheck:
    """
    容器状态检查
    """
    def __init__(self, dev_node, uri_list, lang, logger):
        self.dev_node = dev_node
        self.uri_list = uri_list
        self.lang = lang
        self.logger = logger
        self.all_cli_ret = []
        self.rest = None

    def execute_check(self):
        try:
            self.rest = restUtil.get_container_rest(self.dev_node)
            flag, msg = self.container_base_check()
            return flag, msg

        except (IsmException, JException, Exception):
            self.logger.error(str(traceback.format_exc()))
            err_msg = "query.result.abnormal"
            return cliUtil.RESULT_NOCHECK, common.getMsg(self.lang, err_msg)
        finally:
            if self.rest:
                restUtil.release_container_rest(self.dev_node)

    def container_base_check(self):
        """
        检查容器模块状态
        :return:
        """
        result_list = []
        err_msg_list = []
        for uri in self.uri_list:
            record = restUtil.ContainerRestService.get_for_big(
                self.rest, uri)
            self.all_cli_ret.append(
                unicode(str(record).decode("unicode-escape")))
            flag, msg = restUtil.ContainerRestService.check_response(
                record, self.lang)
            if flag is not True:
                result_list.append(flag)
                err_msg_list.append(msg)
        self.logger.info("result list is:{}".format(result_list))
        return self.merge_result(result_list), "".join(err_msg_list)

    @staticmethod
    def merge_result(result_list):
        """
        结果返回优先级：False，NOCHECK，WARNING，TRUE
        :param result_list:
        :return:
        """
        if False in result_list:
            return False
        if cliUtil.RESULT_NOCHECK in result_list:
            return cliUtil.RESULT_NOCHECK
        if cliUtil.RESULT_WARNING in result_list:
            return cliUtil.RESULT_WARNING
        return True
