# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus

import time

CMD_DEFAULT_TIMEOUT = 60


"""
    执行升级前后检查
"""
def executeCheck(dataDict, command, locationId):
        dev = dataDict.get("dev")
        tlvCon = dataDict.get("tlv")
        
        msgParam0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(0))
        msgParam1 = Param(1, ParamType.STRING, "")
        msgParam2 = Param(2, ParamType.UNSIGN_INT, UnsignedInt32(0))
        msgParam3 = Param(3, ParamType.STRING, "")
        msgParam4 = Param(4, ParamType.STRING, "")
        msgParam5 = Param(5, ParamType.STRING, "")
        msgParam6 = Param(6, ParamType.STRING, "")
        msgParam7 = Param(7, ParamType.STRING, "")
        msgParam8 = Param(8, ParamType.STRING, "")
        ##升级包类型
        pkgTypeVal = 1
        msgParam9 = Param(9, ParamType.UNSIGN_INT, UnsignedInt32(pkgTypeVal))
        msgParam12 = Param(12, ParamType.STRING, command)
        msgParam13 = Param(13, ParamType.UNSIGN_INT, UnsignedInt32(locationId))
        params = TLVUtils.paramList(msgParam0, msgParam1, msgParam2, msgParam3, msgParam4, msgParam5, msgParam6, msgParam7, msgParam8, msgParam9,msgParam12,msgParam13)
        recs = tlvCon.getBatch(CommandConstans.EXC_UPD, params, CMD_DEFAULT_TIMEOUT)
        return recs

"""
   判断是否当前检查项通过了
"""
def isAllItemsPassed(dataDict, UI_CHECK_UPDATE_MSG, checkType):
    
    resource = dataDict.get("resource")
    
    ##判断当前检查项是否是都检查通过了
    checkItems = UI_CHECK_UPDATE_MSG.get("checkitems")
    currentItem = [item for item in checkItems if item['name'] == checkItems[-1]['name']]
    for item in currentItem:
        ## 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
        itemState = item.get("status")
        if 4 == itemState and checkType == "precheck":
            return (False, resource.getString("upgrade.precheck.notpassed"))
        elif 4 == itemState and checkType == "postcheck":
            return (False, resource.getString("upgrade.postcheck.notpassed"))
    
    return (True, "")

"""
   判断是否可忽略检查项都通过,未通过的返回1，即暂停由用户选择操作，
   只对当前检查项进行处理
"""
def isIngnoreItemPassed(dataDict, UI_CHECK_UPDATE_MSG, checkType, checkItemName=''):
    resource = dataDict.get("resource")
    dev = dataDict.get("dev")
    upgradeModel = str(dev.getUpgradeSetInfo().getModel())  # 获取升级执行模式是专家模式或普通

    ##判断当前检查项是否是都检查通过
    isPreCheckPause = True
    checkItems = UI_CHECK_UPDATE_MSG.get("checkitems")
    currentItem = [item for item in checkItems if item['name'] == checkItems[-1]['name']]
    for item in currentItem:
        itemState = item.get("status")
        itemName = item.get("name")
        if 4 == itemState and "precheck" == checkType:
            if "PROFESSIONAL" == upgradeModel:
                return (False, resource.getString("upgrade.precheck.notpassed"), 6)
            isPreCheckPause = False

    if not isPreCheckPause:
        return (False, resource.getString("upgrade.precheck.notpassed"))

    return (True, "", 0)

""" 
    更新忽略后的界面消息
"""
def updateMsgAferIgnore(dataDict, checkItem):
    uiObserver = dataDict.get("uiObserver")
    resource = dataDict.get("resource")
    dev = dataDict.get("dev")
    UI_PRECHCK_UPDATE_MSG = dataDict['UI_PRECHCK_UPDATE_MSG']
    itemMsgList = UI_PRECHCK_UPDATE_MSG.get("checkitems")
    passMsg = resource.getString(checkItem + ".pass")
    itemName = resource.getString(checkItem)
    for itemMsg in itemMsgList:
        if itemMsg["name"] == itemName:
            itemMsg["status"] = 5  # 检查已忽略
            itemMsg["suggession"] = passMsg  # 检查通过

    uiObserver.postMsg(dev, UI_PRECHCK_UPDATE_MSG)
    return

""" 
    更新忽略后的界面消息
"""
def updateMsgAferRetry(dataDict, checkItem):
    uiObserver = dataDict.get("uiObserver")
    resource = dataDict.get("resource")
    dev = dataDict.get("dev")
    UI_PRECHCK_UPDATE_MSG = dataDict['UI_PRECHCK_UPDATE_MSG']
    itemMsgList = UI_PRECHCK_UPDATE_MSG.get("checkitems")
    itemName = resource.getString(checkItem)
    newItemMsgList = []
    for itemMsg in itemMsgList:
        if itemMsg["name"] != itemName:
            newItemMsgList.append(itemMsg)

    UI_PRECHCK_UPDATE_MSG["checkitems"] = newItemMsgList
    uiObserver.postMsg(dev, UI_PRECHCK_UPDATE_MSG)
    return


