# -*- coding: UTF-8 -*-
import resource
import config
from frameone.cli import cliUtil
import os
import logger
from regex import Regex
import java.lang.Exception as JException
import time
import threading

STATUS_NORMAL = "Normal"
STATUS_FAULT = "Fault"
STATUS_ONLINE = "Online"
STATUS_RUNNING = "Running"
STATUS_CHARGING = "Charging"
STATUS_DISCHARGING = "Discharging"
STATUS_ENABLED = "Enabled"
STATUS_YES = "Yes"
STATUS_NO = "No"
STATUS_LINK_UP = "Link Up"
STATUS_LINK_DOWN = "Link Down"
STATUS_ON = "On"
STATUS_OFF = "Off"
STATUS_START = "Start"
STATUS_SYNCHRONIZING = "Synchronizing"
STATUS_PAUSED = "Paused"
STATUS_FORCE_STARTED = "Force Started"
STATUS_INIT = "INIT"
STATUS_STOP = "Stop"

CONTROLLER_INFO = "controller [%s]:\n"
SUPPORT_PRODUCT_MODEL = ["2800 V3"]
MODEL_ONLINE_UPGRADE = "ONLINE"

SLEEP_TIMES = 30
PORTS_BIT_ERROR_SPEC = 60
PORTS_BIT_ERROR_INTERVAL = 10
SERIAL_NUMBER_LENGTH = 20
THRESHOLD_BBU_REMAINING_LIFETIME = 90
THRESHOLD_CONTRL_CPU_USAGE = 80

RESULT_PASS = 0
RESULT_NOTPASS = 1
RESULT_NOCHECK = 2
RESULT_NOSUPPORT = 3
RESULT_WARNING = 4

FILE_SUFFIX = "."
EXPORT_TYPE_RUNNING_DATA = "running_data"
COLLECT_INFO_RECROD_STANDARD = "File Path :"
CONFIG_FILE = "config.txt"
TMP_FILE_NAME = "tmpFileName"

PROGRESS_NUM_1 = 1
PROGRESS_NUM_5 = 5
PROGRESS_NUM_10 = 10
PROGRESS_NUM_15 = 15
PROGRESS_NUM_20 = 20
PROGRESS_NUM_40 = 40
PROGRESS_NUM_60 = 60
PROGRESS_NUM_80 = 80
PROGRESS_NUM_MAX = 100

ENGINE_CTLR_ID_MAP = {"A":1,
                      "B":2,
                      "C":3,
                      "D":4}
LOG_CHECK_SUPPORT_VERSION_LIST = ['V300R001C00',
                         'V300R001C01',
                         'V300R001C10',
                         'V300R001C20',
                         'V300R002',
                         'V300R003',
                         'V300R005',
                         'V300R006C00',
                         'V200R002C20',
                         'V200R002C30',
                         'V100R001C20',
                         'V100R001C30',]

#进度条刷新开始标识和结束标识
PROCESS_STATE_CHECKING = "checking"
PROCESS_UPGRADE_FINISHED = "finished"

def getUpgEvaluationRs(flag, CliRet, errMsg):
    '''
    @summary: 将巡检的结果转为升级评估的结果
    '''
    
    return (cliUtil.RESULT_DICT.get(flag, "2"), CliRet, errMsg)

    
def isAllSameItem(list):
    '''
    @summary: 判断列表是否存在不同的元素
    '''
    flag = "True"
    listLenth = len(list)
    for i in range(0,listLenth):
        if list[i] == "TimeOut":
            return "False"
        for j in range(1,listLenth):
            if list[i] == list[j]:
                continue
            else:
                flag = "False"
    return flag
    
        
def getLang(py_java_env):
    '''
    @summary: 从上下文中获取lang
    @param py_java_env: 上下文对象
    @return: lang
    '''
    return py_java_env.get("lang")
    
def getMsg(lang, msg, args=""):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @return: 经过国际化处理后的消息
    '''
    return cliUtil.getMsg(lang, msg, args, resource.MESSAGES_DICT)

def getSymmetricalPort(port):
    '''
    @summary: 获取端口的对称端口
    @param port: 端口
    '''
    for item in [(".A", ".B"), (".B", ".A"), (".L", ".R"), (".R", ".L")]:
        item0 = item[0]
        item1 = item[1]
        if item0 in port:
            symmetricalPort = port.replace(item0, item1)
            return symmetricalPort
    return ""
            
def checkPCIePortExists(cli, lang):
    '''
    @summary: 判断是否需要检查PCIe端口
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，需要检查PCIe端口
            flag为False时，不需要检查PCIe端口
        errMsg: 错误消息
    '''
    getControllerIdListRet = cliUtil.getControllerIdList(cli, lang)
    if getControllerIdListRet[0] != True:
        return getControllerIdListRet
    
    engSet = set([ctrlId[0] for ctrlId in getControllerIdListRet[1]])
    if len(engSet) <= 1:
        return (True, False, "")
    return (True, True, "")

        
def getBBUConfig(cli, lang):
    '''
    @summary: 获取单个引擎的BBU规格配置
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，BBU规格
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    getProductModelRet = cliUtil.getProductModel(cli, lang)
    if getProductModelRet[0] != True:
        return getProductModelRet
    
    pdtModel = getProductModelRet[1]
    
    if config.BBU_OF_ENGINE_CONFIG_DICT.has_key(pdtModel):
        return (True, config.BBU_OF_ENGINE_CONFIG_DICT.get(pdtModel), "")
    else:
        errMsg = getMsg(lang, "cannot.get.bbu.config")
        return (False, "", errMsg)

def getEngCtrlNum(enclosureID, controllerIdList):
    '''
    @summary: 获取引擎下控制器数量
    @param cli: cli对象
    @param controllerIdList: 控制器ID列表
    @return: 特定引擎下控制器数量
    '''
    
    eng = enclosureID[-1]
    engCtrlNum = len([ctrlId for ctrlId in controllerIdList if eng in ctrlId])
    if engCtrlNum % 2 != 0:
        engCtrlNum += 1
    return engCtrlNum
    
def getEnclosureFanConfig(cli, enclosureInfo, controllerIdList, highDensityDiskEnclosureIdList, lang):
    '''
    @summary: 获取风扇的规格配置
    @param cli: cli对象
    @param enclosureInfo: 机框信息
    @param highDensityDiskEnclosureIdList: 高密框集合
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        ret: 
            flag为True时，风扇的规格
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    storageTypeRet = cliUtil.getStorageType(cli, lang)
    if storageTypeRet[0] != True:
        return storageTypeRet
    product_series = storageTypeRet[1]
    
    enclosureID = enclosureInfo["ID"]
    enclosureHeight = enclosureInfo["Height(U)"]
    
    for enclosureType in ["DSW", "DAE", "ENG", "CTE"]:
        if enclosureType in enclosureID:
            if enclosureHeight == "6" and enclosureType in ["ENG", "CTE"]:
                #6U高端2C和4C场景，都需要2个辅助散热模块，风扇个数一样
                if product_series  == config.SERIES_18000V3:
                    return (True, 12, "")
                #6U中低端2C和4C场景，风扇个数不一样
                else:
                    engCtrlNum = getEngCtrlNum(enclosureID, controllerIdList)
                    return (True, engCtrlNum * 3, "")
            else:
                daeType = "--"
                if enclosureID in highDensityDiskEnclosureIdList:
                    daeType = "high-density"
                key = (enclosureType, enclosureHeight, daeType)
                if config.FAN_CONFIG_DICT.has_key(key):
                    return (True, config.FAN_CONFIG_DICT.get(key), "")
                    
    return (False, "", getMsg(lang, "cannot.get.fan.config"))


def getRealCapacity(capacity):
    '''
    @summary: 获取数值
    '''
    match = Regex.search("\d+\.?\d*", capacity)
    if match != None:
        return match.group()
    else:
        return ""

def getBaseName(file_path):
    '''
    @summary: 返回文件路径的文件名，不包含后缀
    @param file_path:文件路径
    @return: 返回不包含后缀的文件名字符串
    '''
    file_name = os.path.basename(file_path)
    if FILE_SUFFIX in file_name:
        dot_index = file_name.rindex(FILE_SUFFIX)
        return file_name[0:dot_index]
    else:
        return file_name
    
def getLogger(loggerInstance, pyFilePath):
    '''
    @summary: 获取日志类
    @param loggerInstance: logger实例
    @param pyFilePath: py文件路径
    '''
    pyFileName = getBaseName(pyFilePath)
    return logger.Logger(loggerInstance, pyFileName)
    

def getObjAlarmIds(lang, cli, obj):
    '''
    @summary: 根据指定对象查询该对象下的告警ID列表
    @param lang: 语言对象
    @param cli: cli对象
    @param obj: 指定对象
    '''
    alarmIds = set()
    cmd = "show alarm object_type=%s"  % (obj)
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    
    cliRet = checkRet[1]
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    for line in cliRetLinesList:
        alarmId = line["ID"]
        alarmId = str(int(alarmId, 16))
        
        alarmIds.add(alarmId)

    return alarmIds

    
def isSigleModel(cli, lang):
    '''
          控制器模式检查：
                  执行show system config_model命令，查看返回结果：Configuration Model为Multi-Controller时多多控，为Single-Controller时为单控
    '''
    cmd = "show system config_model"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if "single" in cliRet.lower():
        return True
    else:
        return False

def needCheckItem(curVersion, itemPyFilePath):
    '''
    @summary: 判断检查项是否需要检查
    @param itemPyFilePath: 检查项脚本的路径
    @return: True:检查，False：不检查
    '''    
    checkItem = getBaseName(itemPyFilePath)
    involvedVersions =  config.CHECK_ITEMS_INVOLVED_VERSIONS.get(checkItem,[])
    #所有产品版本都涉及该检查项，则配置的涉及版本为”ALL“
    if "ALL" in involvedVersions or curVersion in involvedVersions:
        return True
    else:
        return False

def getUpgEvaluationRsNoInvolved():
    '''
    @summary: 获取不涉及版本时的返回值
    '''
    return getUpgEvaluationRs(True, '', '') 

def getIOdetectEvaluationRsNoInvolved():
    '''
    @summary: 获取“系统挂IO检查”项不涉及版本时的返回值
    '''
    return getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, '', '')

def getCheckResult(resultList):
    """
    @summary:所有控制器的返回情况统一处理。
    @param resultList:返回结果列表 
    """
    for result in cliUtil.RESULT_LIST:
        if result in resultList:
            return result

def getHotPatchVersion(cli, lang):
    '''
    @summary: 热补丁版本号
    @param context: 上下文对象
    @return: 检查是否成功，补丁版本号，cli回显，errMsg
    '''
    errMsg = ""
    hotPatchVersion = ""
    
    cmd = "show upgrade package"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return (checkRet[0], hotPatchVersion, checkRet[1], checkRet[2])
    
    cliRet = checkRet[1]
    beginIndex = cliRet.find('HotPatch Version')
    if beginIndex == -1:
        return (False, hotPatchVersion, checkRet[1], checkRet[2])
    cliRetDictList = cliUtil.getHorizontalCliRet(cliRet[beginIndex:])
    hotPatchVersion = cliRetDictList[0].get('Current Version')
    return (True, hotPatchVersion, cliRet, errMsg)

def getDevVersion(cli, lang, logger):
    '''
    @summary: 获取设备当前运行的系统版本版本
    @param context: 上下文
    @return: 
        flag:
            True:获取设备系统版本成功
            False:获取设备系统版本失败
        devVersion:设备当前运行的系统版本
    '''
    cliRet = ""
    devVersion = ""
    try:
        cmd = "show upgrade package"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True:
            return (False, devVersion, cliRet)
        
        cliRet = checkRet[1]
        endIndex = cliRet.find('HotPatch Version')
        cliRetDictList = cliUtil.getHorizontalCliRet(cliRet[:endIndex])
        devVersion = cliRetDictList[0].get('Current Version')
        return (True, devVersion, cliRet)

    except Exception, exception:
        logger.logException(exception)
        return (False, devVersion, getMsg(lang, "query.result.abnormal"))

def formatVersion(version):
    '''
    @summary: 将版本号转化成有效的版本号（17位：V100R002C00SPC001 或者11位：V100R005C02）
    @param version: 原始版本号
    @return: 有效的版本号
    '''    
    startIndex = version.index("V")
    if Regex.find("SPC", version, Regex.IGNORECASE):
        endIndex = startIndex + 17 #格式：V100R002C00SPC001
    else:
        endIndex = startIndex + 11 #格式：V100R005C02
        
    return version[startIndex:endIndex]

def getVrcVersion(version):
    '''
    @summary: 将版本信息转化为只包含VRC的版本
    @param version: 原始版本号
    @return: 只包含VRC的版本号
    '''
    targetVersion = ""
    try:
        startIndex = version.index("V")
        endIndex = startIndex + 11
        targetVersion = version[startIndex:endIndex]
    except:
        pass
    return targetVersion

def getSpcVersion(version):
    '''
    @summary: 将版本信息转化为只包含VRC的版本
    @param version: 原始版本号
    @return: 只包含VRC的版本号
    '''
    targetVersion = ""
    try:
        startIndex = version.index("V")
        endIndex = startIndex + 17
        targetVersion = version[startIndex:endIndex]
    except:
        pass
    return targetVersion
def isAlarmsExist(cli, lang, logger, alarmIds):
    '''
    @summary: 判断ids是否有id在idList中
    @param alarmIds:配置的告警ids
            @idList:当前设备存在的所有告警list
    '''
    cliRet = ""
    errMsg = ""
    flag = True
    
    try:
        logger.logInfo("alarmIds=%s" % str(alarmIds))
        for alarmId in alarmIds:
            cmd = "show alarm |filterRow column=ID predict=equal_to value=%s" % alarmId
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
            cliRet += checkRet[1]
            
            if checkRet[0] != True:
                errMsg += getMsg(lang, "cannot.get.alarm.info")
                return (checkRet[0], cliRet, errMsg)
            
            #判断回显是否有Command executed successfully
            if cliUtil.queryResultWithNoRecord(checkRet[1]):
                continue
            
            checkList = cliUtil.getHorizontalCliRet(checkRet[1])
            if len(checkList) > 0:
                flag = False
                errMsg += getMsg(lang, "exist.check.alarm", alarmId)
                
        return (flag, cliRet, errMsg)     
        
    except Exception, exception:
        logger.logException(exception)
        return (False, cliRet, getMsg(lang, "query.result.abnormal"))

def isRemoteExistFile(cliRet):
    '''
    @summary: 文件生成5分钟内，不允许再生成。判断是否在限制的时间范围内
    @param cliRet: cli回显
    @return: 
        True: 5分钟内，不允许再生成新的文件
        False: 其他场景
    '''
    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        lowerLine = line.lower()
        if "exporting files" in lowerLine and ("error" in lowerLine or "suggestion" in lowerLine):
            return True
    
    return False
    
def deleteCollectFile(cli, lang, fileType):
    '''
    @summary: 删除远端 类型为fileType的文件
    '''
    cmd = "delete file filetype=%s" % fileType
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True: 
        return checkRet
        
    if cliUtil.queryResultWithNoRecord(checkRet[1]):
        return (True, checkRet[1], "")
    return (False, checkRet[1], getMsg(lang, "delete.collect.file.failed", fileType))

def checkUpgPathBlackList(sourceVersion, desVersion):
    '''
    @summary: 升级路径黑名单检查
    @param param: sourceVer:源版本号，包含SPC版本
    @param param: desVer:目标版本号，包含SPC版本
    @return: 在黑名单中返回True，否则False
    '''
    if sourceVersion in [None,''] or desVersion in [None,'']:
        return False
    
    specialVerList = ['V300R001C10']    #V300R001C10不支持升级到V300R003C20及SPC版本
    
    sourceVer = formatVersion(sourceVersion)
    desVer = formatVersion(desVersion)
    if sourceVer in specialVerList:
        tmpDesVer = getVrcVersion(desVersion)
        if tmpDesVer in config.UPG_PATH_BLACK_DICT.get(sourceVer,[]):
            return True 
        return False       
    
    if desVer in config.UPG_PATH_BLACK_DICT.get(sourceVer,[]):
        return True
    return False


def setProgress(context, progress, item):
    try:
        observer = context.get("progressObserver")
        if observer != None:
            observer.updateItemProgress(context.get("dev"), int(progress), item)
    except (JException, Exception), exption:
        pass


def updateProcess(context, item, totalTime=10, secondTotleTime=20):
    # 剩余时间总数

    oneProgress = 80
    totalReaminTime = totalTime

    secondProgress = 99
    secondReaminTime = secondTotleTime

    UPGRADE_PROCESS_INTEVAL_TIME = 1
    currentPro = 0

    setProgress(context, currentPro, item)

    while context["checkState"] == PROCESS_STATE_CHECKING:
        # 更新进度条
        if totalReaminTime > 0:
            totalReaminTime -= UPGRADE_PROCESS_INTEVAL_TIME
            currentPro = int(oneProgress * (totalTime - totalReaminTime) / totalTime)

        else:
            secondReaminTime -= UPGRADE_PROCESS_INTEVAL_TIME
            if secondReaminTime <= 0:
                setProgress(context, secondProgress, item)
                continue

            currentPro = int(oneProgress + (secondProgress-oneProgress) * (secondTotleTime - secondReaminTime) / secondTotleTime)
        setProgress(context, currentPro, item)
        safeSleep(UPGRADE_PROCESS_INTEVAL_TIME)

    setProgress(context, secondProgress+1, item)
    return


def safeSleep(seconds):
    '''
    @summary: 安全睡眠时间
    @param param: seconds为睡眠时间，单位：秒；数据类型：整数或小数
    '''
    try:
        if type(seconds) not in [int, long, float] or seconds <= 0:
            return

        startTime = time.clock()
        while True:
            if (time.clock() - startTime) >= seconds:
                return

            # 睡眠一下，避免长时间占用cpu，该时间设置过长会影响睡眠时间精度
            try:
                time.sleep(0.1)
            except:
                pass
    except:
        return


def threadUp(context, item, totalTime=10, secondTotleTime=20):
    try:
        t = threading.Thread(target=updateProcess, args=(context, item, totalTime, secondTotleTime))
        t.start()
        context["thread"] = t
    except:
        pass


def threadJoin(context):
    try:
        if context.get("thread") != None:
            context["thread"].join()
    except:
        pass


def finishProcess(context, item):
    context["checkState"] = PROCESS_UPGRADE_FINISHED
    threadJoin(context)
    setProgress(context, PROGRESS_NUM_MAX, item)
    return

def getCurCtlrNode(engineIpMap, curCtlrIp, LOGGER):
    """
    @return: curCtlrNode, NodeMaxNum
    """
    nodeMaxNum = 0
    curCtlrNode = -1
    isfetched = False
    for engId in engineIpMap:
        engineCtlrSum = len(engineIpMap[engId])
        nodeMaxNum += engineCtlrSum
        if engId == '0':
            
            LOGGER.logInfo("current engine's max controller counts: %s" % str(nodeMaxNum))
        for ctlr_info in engineIpMap[engId]:
            if isfetched:
                continue
            if curCtlrIp.strip() == ctlr_info["ip"].strip():
                isfetched = True
            curCtlrNode += 1
    if not isfetched:
        curCtlrNode = -1
    LOGGER.logInfo("current controller's node: %s" % str(curCtlrNode))   
    LOGGER.logInfo("current storage array's max node: %s" % str(nodeMaxNum))     
    return curCtlrNode, nodeMaxNum
    

def heartBeatToOtherCtrl(cli, nodeId, context, LOGGER, LANG):
    '''
    @summary: 心跳至指定节点
    @param cli: cli连接
    @param nodeId: 控制器节点ID
    @return: (flag, errMsg)
        flag:
            True: 命令执行成功
            False: 命令执行失败
        errMsg: 错误消息
    '''
    cmd = "sshtoremoteExt %s" % str(nodeId)
    priKey = context.get("dev").getPriKey()
    if priKey:
        #不支持PublicKey鉴权方式进行心跳控制器
        errMsg = getMsg(LANG, "no.support.publickey.forensics")
        return False, "", errMsg
    
    passWord = context.get("dev").getLoginUser().getPassword()
    
    flag, cliRet, errMsg = sshToRemoteContr(cli, cmd, passWord, LANG)
    if flag != True:
        errMsg = getMsg(LANG, "heart.beat.to.node.failed", nodeId)
    del passWord
    
    return flag, cliRet, errMsg

def sshToRemoteContr(cli, cmd, passWord, lang):
    """
    @summary: 在minisystem模式执行心跳命令到指定的控制器
    """
    allCliRet = ""
    flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, lang)
    allCliRet += cliRet
    if flag != True:
        return (flag, cliRet, errMsg)

    if '(yes/no)?' in cliRet:#首次心跳问题.
        allCliRet += "\n" + cliRet
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, 'yes', True, lang)

    if "password:" in cliRet:
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, passWord, False, lang)
        allCliRet += "\n" + cliRet
        #密码不正确时，退出到minisystem模式，防止持续输错密码导致阵列被锁且模式不正常
        if "password:" in cliRet:
            cliUtil.excuteCtrlC(cli)
            
        if flag != True:
            return (flag, allCliRet, errMsg)
    
    if "System Name" not in cliRet:
        errMsg = getMsg(lang, "ssh.remote.failure")
        return (False, allCliRet, errMsg)

    return (True, allCliRet, errMsg)

def getProductModelWithCliRet(cli, lang):
    '''
    @summary: 获取产品类型并返回CLI回显
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, productModel, ret, errMsg)
        flag:
            True: 获取成功
            False: 获取失败
        productModel:
                                产品型号
        ret: 
            cli回显
        errMsg: 错误消息
    '''
    cmd = "show system general"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return checkRet

    cliRet = checkRet[1]
    cliRetList = cliRet.splitlines()
    product_model = ""
    for line in cliRetList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Product Model":
            product_model = fieldValue

        if len(product_model) != 0 and product_model != "--":
            return True, product_model, cliRet, ""

    return False, "", cliRet, ""
