# -*- coding: UTF-8 -*-
import re 
import java.lang.Exception as JException
from com.huawei.ism.tool.obase.exception import ToolException

STORAGE_MODEL_FLAG = "Storage:~ #"

def search_AlarmId(ssh, alarmID):
    """
    search_AlarmId
            描述：搜索设备是否有告警ID告警。
            返回值：(True/False :是否執行成功, True/False :是否有告警) True 表示有   False表示没有该告警ID
    """
    #过滤命令，只会显示告警ID
    cmdRet = execCmdRetry(ssh, "show alarm |filterColumn include columnList=ID")
    #兼容TR5版本单词拼写错误
    if -1 != cmdRet.find("^"):
        cmdRet = execCmdRetry(ssh, "show alarm |filterColumn include colunmList=ID")
    
    if len(cmdRet.splitlines())  <=3 :
        if re.search("Command executed success", cmdRet, re.IGNORECASE):
            return (True, False) 
        else:
            return (False, False)
           
    #全文搜索查看是否有该告警ID
    if re.search(alarmID, cmdRet, re.IGNORECASE):
        return (True, True)
    
    return (True, False)
# **************************************************************************** #
# 函数名称: changeDeveloper2Debug(ssh)
# 功能说明: 从developer模式进入debug模式
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeDeveloper2Debug(ssh):
    temp = execCmdRetry(ssh, "debug")
    #判断是否进入到了debug模式
    if re.search(":/diagnose>", temp, re.IGNORECASE):
        return True
    #切换失败重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False

# **************************************************************************** #
# 函数名称: changeDebug2Developer(ssh)
# 功能说明: 从debug模式退回到debug模式
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeDebug2Developer(ssh):
    
    temp = execCmdRetry(ssh, "exit")
    #判断是否进入到了debug模式
    if re.search("developer:", temp, re.IGNORECASE):
        return True

    return False

# **************************************************************************** #
# 函数名称: changeCli2Developer
# 功能说明: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Developer(developerPwd, ssh):
    if developerPwd == None or developerPwd == "":
        return False

    temp = execCmdRetry(ssh, "change user_mode current_mode user_mode=developer")

    #判断是否已经developer模式
    if re.search("Password:", temp, re.IGNORECASE):
        temp2 =  execCmdRetry(ssh, developerPwd, False)#False不打印日志
        if re.search("developer:", temp2, re.IGNORECASE):
            return True
    
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False

# **************************************************************************** #
# 函数名称: changeCli2Debug
# 功能说明: 从CLI模式进入debug模式（需要确定使用之前为CLI模式）
# 输入参数: debug密码 ssh连接
# 输出参数: 
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Debug(developerPwd, ssh):
    #切换到developer
    if not changeCli2Developer(developerPwd, ssh):
        return False
    #切换到debug
    if not changeDeveloper2Debug(ssh):
        return False
    #切换成功
    return True
    
# **************************************************************************** #
# 函数名称: changeAnyModel2Cli
# 功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeAnyModel2Cli(ssh):
    counter = 0
    
    while True:
        temp = execCmdWithTimoutRetry(ssh, "show system general", 10)
        #非developer模式下，cli回文正确，则认为回到了cli
        if re.search("System Name", temp, re.IGNORECASE) \
            and not re.search("developer:", temp, re.IGNORECASE):
                break
        #最小系统下要用login admin命令，exit会直接退出连接
        elif re.search("minisystem", temp, re.IGNORECASE):
            temp1 = execCmdWithTimoutRetry(ssh, "logincli", 45)
            #如果logincli命令不存在，则执行exit退出minisystem模式
            if re.search('not exist', temp1, re.IGNORECASE):
                temp2 = execCmdRetry(ssh, "exit")
                if re.search("Are you sure", temp2, re.IGNORECASE):
                    execCmdRetry(ssh, "y")
            #如果密码即将过期，则忽略继续执行
            elif re.search('The password is about to expire', temp1, re.IGNORECASE):
                execCmdRetry(ssh, "n")
        #os_only模式下直接退出
        elif re.search("-bash", temp, re.IGNORECASE):
            break
        #其他情况下，直接exit
        else:
            temp1 = execCmdRetry(ssh, "exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                execCmdRetry(ssh, "y")
        
        #单控的命令模式最多4层
        counter += 1
        if counter >= 4:
            break

# **************************************************************************** #
# 函数名称: changeDeveloper2Minisystem
# 功能说明: 从developer模式进入minisystem模式（需要确定使用之前为developer模式）
# 输入参数: devObj
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeDeveloper2Minisystem(ssh):
    
    #进入minisystem
    temp = execCmdWithTimoutRetry(ssh, "minisystem", 5)

    if re.search("minisystem>", temp, re.IGNORECASE):
        return True
    
    if re.search("Are you sure", temp, re.IGNORECASE):
        temp1 = execCmdRetry(ssh, "y")

        if re.search("minisystem>", temp1, re.IGNORECASE):
            return True

    return False

#-------------------------新增方法------------------------

def execCmdRetry(cli, cmd, isHasLog=True):
    '''
    @summary: 避免cli或ssh服务超时，先对连接进行校验
    @param cli,cmd,isHasLog: 连接，执行的命令，是否打印日志
    @return cliRet: 执行成功与否，命令回显
    '''
    cliRet = ""
    retry_times = 3
    
    for cnt in (0, retry_times):
        try:
            if isHasLog:
                cliRet = cli.execCmd(cmd)
            else:
                cliRet = cli.execCmdNoLog(cmd)
            
            if STORAGE_MODEL_FLAG in cliRet:
                raise
            
            return cliRet
        except ToolException:
            cli.close()
            cli.reConnect()
        except ToolException:
            cli.close()
            cli.reConnect()
        except:
            cli.close()
            cli.reConnect()
    raise


def execCmdWithTimoutRetry(cli, cmd, timeout, isHasLog=True):
    
    cliRet = ""
    retry_times = 3
    
    for cnt in (0, retry_times):
        try:
            if isHasLog:
                cliRet = cli.execCmdWithTimout(cmd, timeout)
            else:
                cliRet = cli.execCmdNoLogTimout(cmd, timeout)
            
            if STORAGE_MODEL_FLAG in cliRet:
                raise
            
            return cliRet
        except ToolException:
            cli.close()
            cli.reConnect()
        except ToolException:
            cli.close()
            cli.reConnect()
        except:
            cli.close()
            cli.reConnect()
    raise


