# -*- coding: UTF-8 -*-
from frameone.util import contextUtil
from frameone.cli import cliUtil
from business.common import common
import re
import traceback
HIGHEND_MODEL_LIST = ['18500','18800','18800F','HVS85T','HVS88T',
                      '18500 V3','18800 V3']
def execu(context):
    '''
    Checking the FC Links Between Arrays
    '''
    cliRet = ""
    errMsg = ""
    isRiskVer, hasShowEventCmd  = curStorageArrayRiskVersionMatchedResult(context)
    if not isRiskVer:
        
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
    checker = DiaEplLinkChecker(context)
    return checker.check(hasShowEventCmd)

def curStorageArrayRiskVersionMatchedResult(context):
    '''
     check whether current storage array needs to check for epl link numbers
     :return isRiskVer, hasShowEventCmd
    '''
    hasShowEventCmd = False
    RISK_VERSION_LIST = ["V200R002C00","V200R002C00SPC100", "V200R002C00SPC200",
                         "V200R002C00SPC300","V200R002C00SPC400", "V200R002C10",
                         "V200R002C20", "V200R002C20SPC200", "V200R002C30",
                         "V100R001C00", "V100R001C00SPC100", "V100R001C00SPC200",
                         "V100R001C00SPC300", "V100R001C10", "V100R001C20",
                         "V100R001C20SPC100", "V100R001C20SPC200", "V100R001C30",
                         "V300R001C00", "V300R001C10", "V300R001C10SPC100",
                         "V300R001C10SPC200", "V300R001C20", "V300R002C10",
                         "V300R002C10SPC100"]
    
    HAS_SHOW_EVENT_VER = {"V200R002" : "V200R002C30",
                          "V100R001" : "V100R001C30",
                          "V300R00"  : "V300R001C00"}
    curVersion = contextUtil.getCurVersion(context)
    curVersion = curVersion.upper().split("SPH")[0]
    common.getLogger(contextUtil.getLogger(context), __file__).logInfo("current device's version " + curVersion)
    if curVersion not in RISK_VERSION_LIST:
        return False, False
    
    for riskVer in  HAS_SHOW_EVENT_VER:
        if riskVer.upper() in curVersion.upper():
            hasShowEventCmd = curVersion >= HAS_SHOW_EVENT_VER[riskVer]
    return True, hasShowEventCmd


class DiaEplLinkChecker():
    """
    class doc :
    """
    def __init__(self, context):
        self.context = context
        self.LANG = contextUtil.getLang(context)
        self.LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
        self.cli = contextUtil.getSSH(context)
        self.sftp = contextUtil.getSFTP(context)
        self.cliRet = ""
        self.errMsg = ""
    def isHighEndDev(self, productModel):
        """
        """
        if productModel in HIGHEND_MODEL_LIST:
            return True
        return False
    def check(self, hasShowEventCmd):
        isSuc, productModel, cliRet, errMsg = common.getProductModelWithCliRet(self.cli, self.LANG)
        self.cliRet +=cliRet
        if not isSuc:
            return common.getUpgEvaluationRs(isSuc, self.cliRet, errMsg)
        self.isHighEnd = self.isHighEndDev(productModel)
        hasException = False
        if hasShowEventCmd:
            try:
                self.LOGGER.logInfo("[EPL_LINK] current device has showevent cmd.")
                return self.checkUsingShowEvent()
            except :
                self.LOGGER.logInfo("exception occurred while checking show event cmd")
                self.LOGGER.logInfo(traceback.format_exc())
                cliUtil.quitfromRemoteNode2OriNode(self.cli, self.LOGGER, self.sftp)
                hasException = True
        if not hasShowEventCmd or hasException:
            self.LOGGER.logInfo("[EPL_LINK]now start to fetch remote FC links using showarray interface.")
            return self.checkUsingShowArray()

    def checkUsingShowEvent(self):
        """
        """
        allUpMtchLmtLinks = {}
        device = self.context.get("dev")
        curIp = device.getIp()
        self.LOGGER.logInfo("current connected controller's ip : %s" % str(curIp))
        enginIpMap = self.getEngineIps()
        curCtlrNode, nodeMaxNum = common.getCurCtlrNode(enginIpMap, curIp, self.LOGGER)
        cmd = "epl showevent"
        if curCtlrNode >= 0:
            self.LOGGER.logInfo("current controller is not high-end device.")
            
            isSucc, cliRet, errMsg = cliUtil.executeCmdInDebugMode(self.cli, cmd, True, 
                                                                   self.LANG, self.context.get("dev").getDeveloperPwd())
            self.cliRet += cliRet
            if not isSucc:
                raise UnCheckException(errMsg)
            if "showevent is not exist" in cliRet.lower():
                self.LOGGER.logInfo("the show event command is not supported, using show array interface.")
                raise UnCheckException(errMsg)
            upLmtLinks = self.parseShowEventIllegal(cliRet)
            self.LOGGER.logInfo("current connected ctlr's up limit links: %s" % str(upLmtLinks))
            if upLmtLinks:
                allUpMtchLmtLinks[curCtlrNode]= upLmtLinks
        if self.isHighEnd:
            allIpDictList = []
            for engine in enginIpMap:
                allIpDictList.extend(enginIpMap[engine])
            for ipDict in allIpDictList:
                if ipDict["ip"] == curIp:
                    continue
                newSSH = self.getNewCliCon(ipDict["ip"])
                if not newSSH:
                    self.LOGGER.logInfo("failed to connect to high-end's controller: %s" % ipDict["name"])
                    raise UnCheckException(errMsg)
                isSucc, cliRet, errMsg = cliUtil.executeCmdInDebugMode(newSSH, cmd, True, 
                                                                       self.LANG, self.context.get("dev").getDeveloperPwd())
                cliUtil.closeCliConnection(newSSH)
                self.cliRet += cliRet
                if not isSucc:
                    raise UnCheckException(errMsg)
                upLmtLinks = self.parseShowEventIllegal(cliRet)
                if upLmtLinks:
                    allUpMtchLmtLinks[ipDict["name"]]= upLmtLinks
        else:
            for nodeId in range(nodeMaxNum):
                if nodeId == curCtlrNode:
                    continue
                flag, cliRet, errMsg = common.heartBeatToOtherCtrl(self.cli, nodeId, self.context, self.LOGGER, self.LANG)
                self.cliRet += cliRet
                if flag != True:
                    raise UnCheckException(errMsg)
                isSucc, cliRet, errMsg = cliUtil.executeCmdInDebugMode(self.cli, cmd, True, 
                                                                       self.LANG, self.context.get("dev").getDeveloperPwd())
                self.cliRet += cliRet
                if not isSucc:
                    raise UnCheckException(errMsg)
                upLmtLinks = self.parseShowEventIllegal(cliRet)
                if upLmtLinks:
                    allUpMtchLmtLinks[nodeId]= upLmtLinks
                common.quitfromRemoteNode2OriNode(self.cli, self.LOGGER, self.sftp)
        return self.parseShowArrayResults(None, None, allUpMtchLmtLinks, None)
            
            
    def parseShowEventIllegal(self, cliRet):
        """
        @return:  upLinks  {arrayId:{lwwpn:counts}}
        """
        arrayPoi = -1
        typePoi = -1
        lwwpnPoi = -1
        rwwpnPoi = -1
        statePoi = -1
        # pattern {arrayId:{key:"l+r",value:[lwwpn]}}
        allLinks = {}
        for line in cliRet.splitlines():
            if "array" in line.lower() and "stat" in line.lower() \
                and "lwwpn/lip" in line.lower() and "rwwpn/rip" in line.lower() \
                and "type" in line.lower():
                params = line.lower().split()
                arrayPoi = params.index("array")
                typePoi  = params.index("type")
                lwwpnPoi  = params.index("lwwpn/lip")
                rwwpnPoi  = params.index("rwwpn/rip")
                statePoi = params.index("stat")
                continue
            if ">" in line:
                break
            params = line.split()
            portType = params[typePoi]
            if portType.lower() != "fc":
                continue
            array = params[arrayPoi]
            lwwpn = params[lwwpnPoi]
            rwwpn = params[rwwpnPoi]
            state = params[statePoi]
            if not allLinks.get(array,""):
                allLinks[array] = {}
            if allLinks[array].get(lwwpn + rwwpn, ""):
                continue
            allLinks[array][lwwpn + rwwpn] = [lwwpn, state]
        self.LOGGER.logInfo("all links on current ctlr: %s" % str(allLinks))
        upLinks = {}
        for array in allLinks:
            upLinkDict = {}
            for wwpnKey in allLinks[array]:
                if allLinks[array][wwpnKey][1].lower() == "up" :
                    lwwpn = allLinks[array][wwpnKey][0]
                    upLinkDict[lwwpn] = upLinkDict.get(lwwpn, 0) + 1
            self.LOGGER.logInfo("after parsing, up links counts on current ctlr: %s" % str(upLinkDict))
            totalCount = 0
            for lwwpn in upLinkDict:
                totalCount += upLinkDict[lwwpn]
            if totalCount > 8:
                upLinks[array] = upLinkDict
        
        return upLinks
    
    def checkUsingShowArray(self):
        """
        @summary:  check using epl showarray command to check
        """
        failedArrays = []
        # {arrayId : {ctlrId: [upLinkWWPNs]}}
        UpLinks = {}
        ArrayLinks = {}
        cmd = "epl showarray"
        newCli = self.cli
        if self.isHighEnd:
            newCli = self.getOtherCliConn()
            if not  newCli:
                self.LOGGER.logInfo("[EPL_LINK]high-end dev failed to build con to other ctlr.")
                errMsg = common.getMsg(self.LANG,"ssh.connect.fail")
                return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, self.cliRet, errMsg)
        isSucc, cliRet, errMsg = cliUtil.executeCmdInDebugMode(newCli, cmd, True, 
                                                               self.LANG, self.context.get("dev").getDeveloperPwd())
        self.cliRet += cliRet
        
        if not isSucc:
            self.LOGGER.logInfo("[EPL_LINK]failed to enter debug mode or showarray cmd exe failed.")
            self.LOGGER.logInfo("[EPL_LINK] ErrMsg:" + errMsg)
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, self.cliRet, errMsg)
        arrayIds = []
        isStart =False
        for line in cliRet.splitlines():
            line = line.strip()
            if re.search("^ID", line, re.IGNORECASE):
                isStart = True
                continue
            if isStart and ">" not in line:
                arrayId = line.split()[0]
                if arrayId.isdigit():
                    arrayIds.append(arrayId.strip())
        self.LOGGER.logInfo("[EPL_LINK]current device's remote array ids:%s" % ",".join(arrayIds) )
        for arrayId in arrayIds:
            cmd = "epl showarray -a %s" % arrayId
            isSucc, cliRet, errMsg = cliUtil.executeCmdInDebugMode(newCli, cmd, True, 
                                                                   self.LANG, self.context.get("dev").getDeveloperPwd())
            self.cliRet += cliRet
            if not isSucc:
                self.LOGGER.logInfo("[EPL_LINK]showarray cmd on array %s's failed to exec." % str(arrayId)) 
                failedArrays.append(arrayId)
            uplinks, totalLinks = self.parseShowArrayDetails(cliRet)
            if uplinks:
                UpLinks[arrayId] = uplinks
            if totalLinks:
                ArrayLinks[arrayId] = totalLinks
        self.LOGGER.logInfo("[EPL_LINK]Storage Arrays' UP status LINKS: %s." % str(UpLinks))
        self.LOGGER.logInfo("[EPL_LINK]Storage Arrays' total LINKS: %s." % str(ArrayLinks))
                
        return self.parseShowArrayResults(failedArrays, UpLinks, None, ArrayLinks)
    
    def parseShowArrayResults(self, failedArrays, UpLinks, accArrayLinkMaps, ArrayLinkMaps):
        """
        :param failedArrays
        :param UpLinks Array FC link dict whose status is UP
        :param accArrayLinkMaps accurate Array FC link dict(using showevent cmd)
        :param ArrayLinkMaps  non-accurate array FC link dict(using showarray cmd)
        """
        result = True
        errMsg = ""
        if failedArrays:
            self.LOGGER.logInfo("found failed querying arrays, the result is not check." )
                        
            result = cliUtil.RESULT_NOCHECK
            errMsg += common.getMsg(self.LANG, "failed.check.following.arrays.epl.link",
                                                 ",".join(failedArrays))
        if ArrayLinkMaps:
            for arrayId in ArrayLinkMaps:
                for ctrlNo in ArrayLinkMaps[arrayId]:
                    if len(ArrayLinkMaps[arrayId][ctrlNo]) == 8:
                        self.LOGGER.logInfo("found array %s's ctlr %s's link not accurate sum: %s,the result is warning." %
                                            (arrayId, ctrlNo, str(len(ArrayLinkMaps[arrayId][ctrlNo]))))
                        result = cliUtil.RESULT_WARNING
                        errMsg += common.getMsg(self.LANG, 
                                                "check.array.epl.link.is.overloaded",
                                                (ctrlNo, arrayId, 
                                                 ",".join(ArrayLinkMaps[arrayId][ctrlNo])))
        if accArrayLinkMaps:
            for ctrlNo in accArrayLinkMaps:
                for arrayId in accArrayLinkMaps[ctrlNo]:
                    total = 0
                    for wwpn in accArrayLinkMaps[ctrlNo][arrayId]:
                        total += accArrayLinkMaps[ctrlNo][arrayId][wwpn]
                    if total > 8:
                        self.LOGGER.logInfo("found array %s's ctlr %s's link sum: %s,the result is failed." %
                                            (arrayId, ctrlNo, str(len(accArrayLinkMaps[ctrlNo][arrayId]))))
                        result = False
                        errMsg += common.getMsg(self.LANG, 
                                                "check.array.epl.link.is.overloaded",
                                                (ctrlNo, arrayId, 
                                                 accArrayLinkMaps[ctrlNo][arrayId].keys()))
        # {arrayId : {ctlrId: [upLinkWWPNs]}}
        if UpLinks:
            self.LOGGER.logInfo("found Up status links,the result is failed.")
            result = False
            for arrayId in UpLinks:
                for ctrlNo in UpLinks[arrayId]:
                    errMsg += common.getMsg(self.LANG, 
                                        "check.array.follow.epl.link.not.normal",
                                        (ctrlNo, arrayId, 
                                         ",".join(UpLinks[arrayId][ctrlNo])))
        self.LOGGER.logInfo("errmsg:" + errMsg)
        return  common.getUpgEvaluationRs(result, self.cliRet, errMsg)
            
    def parseShowArrayDetails(self, cliRet):
        """
        """
        uplinks = {}
        totalLinks = {}
        curCtlr = ''
        isNextLineStatus = False 
        tempStatus = ""
        iniWwpn = ""
        for line in cliRet.splitlines():
            if re.search("ctrl\s[0-9]+'s\slink", line, re.I):
                curCtlr = re.search("[0-9]+", line, re.I).group()
                continue
            if "status" in line.lower().replace(" ","").strip() and \
                'linktype' in line.lower().replace(" ","").strip() :
                if tempStatus and iniWwpn and curCtlr:
                    if tempStatus.strip().lower() == "up":
                        uplinks[curCtlr] = uplinks.get(curCtlr, "")
                        if uplinks.get(curCtlr, ""):
                            uplinks[curCtlr].append(iniWwpn)
                        else:
                            uplinks[curCtlr] = [iniWwpn]
                    if totalLinks.get(curCtlr, ""):
                        totalLinks[curCtlr].append(iniWwpn)
                    else:
                        totalLinks[curCtlr] = [iniWwpn]
                    tempStatus = ""
                    iniWwpn = ""
                        
                isNextLineStatus = True
                
                continue
            if  isNextLineStatus:
                isNextLineStatus = False
                if "FC" in line.upper() :
                    if "UP" in line.upper():
                        tempStatus = "up"
                    else:
                        tempStatus = "others"
                else:
                    self.LOGGER.logInfo("current link's type is not FC.")
                continue
            if re.search("^ini:[\s]*[0-9a-zA-Z]+", line.strip(),re.I):
                iniWwpn = re.search("[0-9a-zA-Z]+",line.split(":")[1],re.I).group()
                continue
            if "----" in line:
                if tempStatus and iniWwpn and curCtlr:
                    if tempStatus.strip().lower() == "up":
                        uplinks[curCtlr] = uplinks.get(curCtlr, "")
                        if uplinks.get(curCtlr, ""):
                            uplinks[curCtlr].append(iniWwpn)
                        else:
                            uplinks[curCtlr] = [iniWwpn]
                    if totalLinks.get(curCtlr, ""):
                        totalLinks[curCtlr].append(iniWwpn)
                    else:
                        totalLinks[curCtlr] = [iniWwpn]
                    tempStatus = ""
                    iniWwpn = ""
                curCtlr = ""
        return uplinks, totalLinks
                
    def getEngineIps(self):
        """
        @summary: 获取引擎配置的管理IP 映射关系
        @return: 
        """
        cmd = "show upgrade package"
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(self.cli, cmd, True, self.LANG)
        self.cliRet += cliRet
        if flag != True:
            errMsg = common.getMsg(self.LANG, "query.result.abnormal")
            self.LOGGER.logInfo("failed to execute show upgrade package command!")
            raise UnCheckException(errMsg)
        
        beginIndex = cliRet.find("Software Version")
        endIndex = cliRet.find("HotPatch Version")
        infoDictList = cliUtil.getHorizontalCliRet(cliRet[beginIndex : endIndex])
        
        if len(infoDictList) == 0:
            errMsg = common.getMsg(self.LANG, "query.result.abnormal")
            raise UnCheckException(errMsg)
        
        engineIpsDict = {}
        
        for infoDict in infoDictList:
            ip = infoDict.get("IP")
            contrName = infoDict.get("Name")
            if ip and contrName and "." in ip:
                # 取0号元素
                engine = contrName[:1]
                ipList = engineIpsDict.get(engine, [])
                ipList.append({"name" : contrName, "ip" : ip})
                engineIpsDict[engine] = ipList
        
        return engineIpsDict
    
    def getOtherCliConn(self):
        """
        """
        isSuc, ctlrIps = cliUtil.getCtrlIps(self.cli, self.LOGGER, self.LANG)
        if not isSuc:
            self.LOGGER.logInfo("[EPL_LINK] failed to check other controller's ip list.")
            return None
        self.LOGGER.logInfo("[EPL_LINK] current device's lp Lists:%s" % str(ctlrIps))
        for ctlrIp in ctlrIps:
            ip = ctlrIp[1]
            newCli = contextUtil.createCliConnection(self.context, ip)
            if newCli:
                self.LOGGER.logInfo("[EPL_LINK] successfully build con to %s" % str(ip))
                return newCli
    def getNewCliCon(self, ip):
        """
        @summary: get specified new connection to giving ip addr
        """
        newCli = contextUtil.createCliConnection(self.context, ip)
        if newCli:
            self.LOGGER.logInfo("[EPL_LINK] successfully build con to %s" % str(ip))
        return newCli
        
class UnCheckException:
    """
    @summary: 未检查异常自定义类
    """
    def __init__(self, errorMsg):
        self.errorMsg = errorMsg
        