# -*- coding: UTF-8 -*-
import traceback
import saveDevSceneData
import threading
import traceback
import time
from function import StorageContextUtil
from frameone.cli import cliUtil
from frameone.util import contextUtil
from business.service import show_lun_capacity_in_precise_mode
from business.service import query_logical_port_info
from cbb.frame.base import product
from business.service import save_nvme_for_storage
from business.service import save_os_wwn_for_host
from business.service import saveDevDataCustom

locker = threading.Lock()

GLOBAL_MAX_RETRY_TIMES = 5
'''
确认支持的版本范围？
'''
from frameone.adapter.resourceService import ResrouceFactory


class GlobalNetworkThreahold:

    def __init__(self):
        self.globalRetyTimes = 0

    def getGlobalRetyTimes(self):
        return self.globalRetyTimes

    def setGlobalRetyTimes(self, logger, isClear=False):
        locker.acquire()
        if isClear:
            self.globalRetyTimes = 0
        else:
            self.globalRetyTimes += 1
            logger.info("[queryStgInfo4HostEv]currently failed connecting for %s times " % self.globalRetyTimes)
        locker.release()


gth = GlobalNetworkThreahold()


def execute(context):
    logger = contextUtil.getLogger(context)
    try:

        response = QueryStorageInfo(context).process()
        response = str(response).replace("u'", "'")
        logger.info("[queryStgInfo4HostEv]QueryStorageInfo response=%s" % response)

        checkFlag, checkMsg = saveDevSceneData.execute(context)
        logger.info("[queryStgInfo4HostEv]saveDevSceneData result=%s" % checkFlag)
        logger.info("[queryStgInfo4HostEv]saveDevSceneData checkMsg=%s" % checkMsg)

        checkFlag, checkMsg = saveDevDataCustom.execute(context)
        logger.info("[queryStgInfo4HostEv]saveDevDataCustom result=%s"
                    % checkFlag)
        logger.info("[queryStgInfo4HostEv]saveDevDataCustom checkMsg=%s"
                    % checkMsg)

        checkFlag, checkMsg = save_nvme_for_storage.execute(context)
        logger.info("[queryStgInfoNvme]saveNvmeForStorage result=%s"
                    % checkFlag)
        logger.info("[queryStgInfoNvme]saveNvmeForStorage checkMsg=%s"
                    % checkMsg)

        checkFlag, checkMsg = save_os_wwn_for_host.execute(context)
        logger.info("[queryStgInfohostOsWwn]saveOsWwnForHost result={}, checkMsg={}".format(checkFlag, checkMsg))

        # 装载LUN容量一致性检查数据
        show_lun_capacity_in_precise_mode. \
            ShowLunCapacityInPreciseMode(context).execute()

        query_logical_port_info.QueryLogicalPortIp(context).query()
        return True, response
    except:
        logger.info("[queryStgInfo4HostEv]excute queryStorageinfo4HostEvalu exception.[%s]" % traceback.format_exc())
        return False, ""
    finally:
        try:
            rest = contextUtil.getRest(context)
            rest.close()
        except Exception as e:
            logger.error("[queryStgInfo4HostEv]release rest connection "
                         "exception.[%s]" % str(e))


class QueryStorageInfo():
    def __init__(self, context):
        self.context = context
        self.resourceService = ResrouceFactory(context)
        self.response = StorageInfo(contextUtil.getDevSN(context), contextUtil.getIp(context))

    def need_query_NVMe_initiator(self):
        dev_version = contextUtil.getCurVersion(self.context)
        if product.isDigitalVer(dev_version) and dev_version >= "6.1.0":
            return True
        if product.compare_version(dev_version, "V700R001C00") >= 0:
            return True
        return False

    def process(self):
        self.response.contains_nfs_service = StorageNfsService(self.context). \
            is_storage_contains_nfs_service()

        logger = contextUtil.getLogger(self.context)
        allHosts = self.resourceService.executeInterface("getHost")
        total = allHosts and len(allHosts) or 0
        bar = ProgressBar(total, self.context)

        fcThread = HostInfoCheckThread('FC-Initr_thread', allHosts, self.resourceService, logger,
                                       bar, 'FC initiator', 'getFcInitiator')
        iSCSIThread = HostInfoCheckThread('iSCSI-Initr_thread', allHosts, self.resourceService, logger,
                                          bar, 'iSCSI initiator', 'getIscsiInitiator')

        NVMeThread = HostInfoCheckThread(
            'NVMe-Initr_thread', allHosts, self.resourceService, logger, bar,
            'NVMe initiator', 'getNVMeInitiator')

        ibThread = HostInfoCheckThread('IB-Initr_thread', allHosts, self.resourceService, logger,
                                       bar, 'IB initiator', 'getIbInitiator')
        hostLinkThread = HostInfoCheckThread('Host_Link_thread', allHosts, self.resourceService, logger,
                                             bar, 'Host Links', 'getHostLink')
        lunCountThread = HostInfoCheckThread('HostLun_Count_thread', allHosts, self.resourceService, logger,
                                             bar, 'Host Lun Count', 'getHostLunAndSnapCount')

        threads = [fcThread, iSCSIThread, ibThread, hostLinkThread, lunCountThread]
        if self.need_query_NVMe_initiator():
            threads.append(NVMeThread)

        for td in threads:
            td.start()

        for td in threads:
            td.join()

        logger.info("[queryStgInfo4HostEv]all thread had finished running, now start to fetch host info.")
        self.response.errorCode = 0
        self.response.errorMsg = ''
        hasFailed = False
        for hostDict in allHosts:
            isFailed = False
            failedItems = []

            hostInfo = HostInfo(hostDict)
            singleHost = hostInfo.hostId
            hostInfo.addInitiator(fcThread.get_result()[singleHost])
            logger.info("test:" + str(fcThread.get_result()[singleHost]))
            if fcThread.get_result()[singleHost] is None:
                failedItems.append(fcThread.cmdId)
                isFailed = True
            hostInfo.addInitiator(iSCSIThread.get_result()[singleHost])
            if iSCSIThread.get_result()[singleHost] is None:
                failedItems.append(iSCSIThread.cmdId)
                isFailed = True
            hostInfo.addInitiator(ibThread.get_result()[singleHost])

            if self.need_query_NVMe_initiator():
                if NVMeThread.get_result()[singleHost] is None:
                    failedItems.append(NVMeThread.cmdId)
                    isFailed = True
                hostInfo.addInitiator(NVMeThread.get_result()[singleHost])

            if ibThread.get_result()[singleHost] is None:
                failedItems.append(ibThread.cmdId)
                isFailed = True
            hostInfo.setHostLink(hostLinkThread.get_result()[singleHost])
            if hostLinkThread.get_result()[singleHost] is None:
                failedItems.append(hostLinkThread.cmdId)
                isFailed = True
            lunNumRet = lunCountThread.get_result()[singleHost]
            if lunNumRet is None:
                failedItems.append(fcThread.cmdId)
                isFailed = True

            else:
                hostInfo.lunNum = lunNumRet.get("COUNT")
                if hostInfo.initiatorNum is None:
                    hostInfo.initiatorNum = str(len(hostInfo.initiators))
            hostInfo.failedInterfaces = failedItems
            logger.info("[queryStgInfo4HostEv]host %s failed to fetch the following info:%s." % (
                hostInfo.hostId, ",".join(hostInfo.failedInterfaces)))
            hasFailed = hasFailed or isFailed
            self.response.addHost(hostInfo)

            if hasFailed:
                errMsg = "failed.query.storage.host.configs"
                self.response.errorCode = -1
                self.response.errorMsg = errMsg

        return self.response.toDict()


class StorageInfo():
    def __init__(self, sn, ip):
        self.storageSn = str(sn)
        self.storageIp = str(ip)
        self.hosts = []
        self.contains_nfs_service = False
        self.errorCode = None
        self.errorMsg = ''

    def addHost(self, host):
        hostDetailInfo = host.toDict()
        self.hosts.append(hostDetailInfo)

    def toDict(self):
        return dict(storageSn=self.storageSn, storageIp=self.storageIp,
                    errorMsg=self.errorMsg, errorCode=self.errorCode,
                    hostList=self.hosts,
                    containsNfs=str(self.contains_nfs_service).lower())


class HostInfo():
    def __init__(self, host):
        self.hostId = host.get("ID")
        self.hostName = host.get("NAME")
        self.runningStatus = host.get("RUNNINGSTATUS")
        self.isAdd2HostGroup = host.get("ISADD2HOSTGROUP")
        self.initiatorNum = host.get("INITIATORNUM")
        self.initiators = []
        self.hostLink = []
        self.lunNum = None
        self.failedInterfaces = []

    def addInitiator(self, initiators):
        SECTORS = ["ID", "TYPE", "RUNNINGSTATUS", "MULTIPATHTYPE"]
        self.initiators.extend(self.filterSector(initiators, SECTORS, ['ID']))

    def setHostLink(self, links):
        SECTORS = ["CTRL_ID", "HEALTHSTATUS", "ID", "INITIATOR_ID", "INITIATOR_PORT_WWN",
                   "INITIATOR_TYPE", "RUNNINGSTATUS", "TARGET_ID", "TARGET_PORT_WWN", "TARGET_TYPE", "ULTRAPATHVERSION"]
        self.hostLink = self.filterSector(links, SECTORS, ['INITIATOR_PORT_WWN'])

    def filterSector(self, datas, sectors, upperSectrs=[]):
        rets = []
        if datas:
            for data in datas:
                tmpDict = dict()
                for sector in sectors:
                    if sector in upperSectrs:

                        tmpDict[sector] = str(data.get(sector, "")).upper()
                    else:
                        tmpDict[sector] = str(data.get(sector, ""))
                rets.append(tmpDict)
        return rets

    def toDict(self):
        return dict(hostId=self.hostId, hostName=self.hostName, runningStatus=self.runningStatus,
                    isAdd2HostGroup=self.isAdd2HostGroup, initiatorNum=self.initiatorNum,
                    lunNum=self.lunNum, initList=self.initiators, pathsList=self.hostLink,
                    failedInterfaces=self.failedInterfaces)


class HostInfoCheckThread(threading.Thread):
    """
    classDoc
    """

    def __init__(self, tdId, hostQueue, service, logger, progressProcessor, cmdId, cmd):
        """

        """
        super(HostInfoCheckThread, self).__init__()
        self.__result = {}
        self.resourceService = service
        self.logger = logger
        self.hostQueue = hostQueue
        self.progressProcessor = progressProcessor
        self.threadId = tdId
        self.cmdId = cmdId
        self.cmd = cmd
        self.logger.info("[queryStgInfo4HostEv][host check thread] %s had been initialized." % self.threadId)

    def get_result(self):
        """

        :return: hostInfo instance
        """
        return self.__result

    def getServiceResultAndRefreshProgress(self, hostInfo):
        """

        :param key: TLV interface desc
        :param uri: TLV cmd KEY
        :param hostInfo:
        :return:
        """
        global gth
        hostId = hostInfo.hostId
        serviceResult = None
        for i in range(3):
            try:
                serviceResult = self.resourceService.executeInterface(self.cmd, hostId)
                self.logger.info(
                    "[queryStgInfo4HostEv][hostCheck Thread-%s]host %s finished fetching %s." % (
                        self.threadId, hostId, self.cmdId))
                gth.setGlobalRetyTimes(self.logger, True)
                break
            except:
                gth.setGlobalRetyTimes(self.logger)
                if gth.getGlobalRetyTimes() > GLOBAL_MAX_RETRY_TIMES:
                    raise Exception("Too much retry times, may the connection is interrupted.")
                self.logger.error(
                    "[queryStgInfo4HostEv][hostCheck Thread-%s]host %s failed to fetch %s information." % (
                        self.threadId, hostId, self.cmdId))
                self.logger.error("trackback:" + traceback.format_exc())
                self.logger.info("retry after 2 seconds")
                serviceResult = None
                time.sleep(1)
                continue
        self.progressProcessor.refreshOneStepFinished()
        return serviceResult

    def run(self):
        """

        :return:
        """
        try:
            self.logger.info("[queryStgInfo4HostEv][hostCheck Thread-%s] now start to work." % self.threadId)
            for host in self.hostQueue:
                hostInfo = HostInfo(host)

                serviceResult = self.getServiceResultAndRefreshProgress(hostInfo)
                self.logger.info("host:" + str(host))
                self.logger.info("result:" + str(serviceResult))
                self.__result[hostInfo.hostId] = serviceResult

                self.logger.info(
                    "[queryStgInfo4HostEv][hostCheck Thread-%s] host %s finished fetching initiator info." % (
                        self.threadId, hostInfo.hostId))

            self.logger.info("[queryStgInfo4HostEv][hostCheck Thread-%s]finished fetching hosts infos." % self.threadId)
        except:
            self.logger.error(traceback.format_exc())


class StorageNfsService(object):

    def __init__(self, context):
        self._context = context
        self._logger = StorageContextUtil.getLogger(context)
        self._cli = contextUtil.getCLI(context)
        self._lang = StorageContextUtil.getLang(context)

    def is_storage_contains_nfs_service(self):
        cmd = r"show logical_port general|filterColumn include columnList=" \
              r"Support\sProtocol"
        flag, cli_ret, _ = cliUtil.excuteCmdInCliMode(
            self._cli, cmd, True, self._lang)
        if not cliUtil.hasCliExecPrivilege(cli_ret):
            return False
        if flag is not True:
            raise Exception("query logical port general failed.")
        if cliUtil.queryResultWithNoRecord(cli_ret):
            return False
        cli_ret_lines_list = cliUtil.getHorizontalCliRet(cli_ret)
        if len(cli_ret_lines_list) == 0:
            raise Exception("parse logical port general failed.")

        for cli_ret_line in cli_ret_lines_list:
            if "NFS" in cli_ret_line.get("Support Protocol", "--"):
                return True
        return False


class ProgressBar():
    def __init__(self, totalCount, context):
        """

        """
        self.context = context
        self.fullprogress = 100.0
        self.oneStepLen = self.fullprogress / (totalCount * 5 + 1)
        self.curProgress = 0.0
        self.refreshOneStepFinished()

    def refreshOneStepFinished(self):
        """

        :return: None
        """
        locker.acquire()
        self.curProgress += self.oneStepLen
        if self.curProgress <= self.fullprogress:
            self.context.get("progressWiper").refresh(round(self.curProgress, 2))
        locker.release()

    def refreshFinished(self, resultStatus, errMsg):
        """

        :return:
        """
        locker.acquire()
        self.context.get("progressWiper").finish(resultStatus, errMsg)
        locker.release()
