#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@time: 2020/06/18
@file: query_logical_port_info.py
@function:
"""
import json

from function import StorageContextUtil
from frameone.cli import cliUtil
from frameone.util import contextUtil


class QueryLogicalPortIp(object):

    def __init__(self, context):
        self._context = context
        self._logger = StorageContextUtil.getLogger(context)
        self._cli = contextUtil.getCLI(context)
        self._lang = StorageContextUtil.getLang(context)
        self._cli_ret = ""
        self._ip_list = list()

    def query(self):
        try:
            cmd = "show logical_port general"
            flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(
                self._cli, cmd, True, self._lang)
            self._cli_ret = cli_ret
            if not cliUtil.hasCliExecPrivilege(cli_ret):
                self.build_result_to_scene_data(True)
                return
            if flag is not True:
                self.build_result_to_scene_data(False)
                return
            if cliUtil.queryResultWithNoRecord(cli_ret):
                self.build_result_to_scene_data(True)
                return
            cli_ret_lines_list = cliUtil.getHorizontalCliRet(cli_ret)
            if len(cli_ret_lines_list) == 0:
                self._logger.error("parse logical port info failed.")
                self.build_result_to_scene_data(False)
                return
            for cli_ret_line in cli_ret_lines_list:
                ipv4 = cli_ret_line.get("IPv4 Address", "--")
                ipv6 = cli_ret_line.get("IPv6 Address", "--")
                if ipv4 != "--":
                    self._ip_list.append(ipv4)
                if ipv6 != "--":
                    self._ip_list.append(ipv6)
            self.build_result_to_scene_data(True)
        except Exception as exception:
            self._logger.error("query_logical_port error: {}".format(
                str(exception)))
            self.build_result_to_scene_data(False)

    def build_result_to_scene_data(self, had_query_success):
        dev_sn = StorageContextUtil.getDevSN(self._context)
        scene_data_instance = StorageContextUtil.getSceneDataExchangeObj(
            self._context)
        luns_in_precise_mode = {"query_flag": had_query_success,
                                "cli_ret":  self._cli_ret,
                                "ip_list": self._ip_list}
        item = dev_sn + "_query_logical_port_ip"
        scene_data_instance.saveKV(item, json.dumps(luns_in_precise_mode))
