# -*- coding: UTF-8 -*-

from function import StorageContextUtil
from function import StorageResource

from frameone.cli import cliUtil
from java.lang import Exception as JException

import json


def execute(context):
    '''
    @summary: 入口程序 执行自定义命令并保存回显
    @param context: 上下文对象
    '''

    logger = StorageContextUtil.getLogger(context)
    lang = StorageContextUtil.getLang(context)

    try:
        storage_nvme_executer = StorageNvmeExecuter(context)
        flag, storage_nqn_info_str = \
            storage_nvme_executer.get_storage_nqn_info()

        dev_sn = StorageContextUtil.getDevSN(context)
        _save_device_info(context, dev_sn + "_storageNqnInfo",
                          storage_nqn_info_str)
        return True, ""
    except (Exception, JException) as e:
        logger.error("[saveNvmeDataCustom] error: " + str(e))
        return False, StorageResource.getMsg(lang, "query.result.abnormal")


def _save_device_info(context, item, save_info):
    '''
    @summary: 保存相关的设备信息
    @param context: 上下文对象
    '''
    logger = StorageContextUtil.getLogger(context)
    scene_data_instance = StorageContextUtil.getSceneDataExchangeObj(context)
    logger.info("[_saveDeviceInfo] save item: " + item)
    scene_data_instance.saveKV(item, save_info)


class StorageNvmeExecuter():
    """
    查询阵列侧的所有主机、及影响的启动器和LUN信息
    返回的json数据格式如下：
    {
    "faliCommand":"",
    "cliRets": "",
    "nvme_initiator": []
    }
    """
    def __init__(self, context):
        self.context = context
        self.logger = StorageContextUtil.getLogger(context)
        self.lang = StorageContextUtil.getLang(context)
        self.cli = StorageContextUtil.getSSH(context)
        self.result = dict(failCommand="",
                           cliRets="", result="nocheck", nvme_initiator=list())

    def append_cli_rets(self, cli_ret):
        all_cli_rets = self.result.get("cliRets")
        all_cli_rets += cli_ret + "\n"
        self.result["cliRets"] = all_cli_rets

    def get_storage_nvme_initiator(self):
        cmd = "show nvme_over_roce_initiator general"
        status, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(
            self.cli, cmd, True, self.lang)
        self.append_cli_rets(cli_ret)
        if not cliUtil.hasCliExecPrivilege(cli_ret):
            return True
        if status is not True:
            self.logger.error(
                "[git_nvme_initiator] get nvme initiator error msg:%s"
                % err_msg)
            self.result["failCommand"] = cmd
            return False

        nvme_initiator = self.result.get("nvme_initiator")
        cli_dict_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
        for nvme_over_roce_initiator in cli_dict_list:
            nvme_nqn = nvme_over_roce_initiator.get("NQN")
            nvme_initiator.append(nvme_nqn)
        return True

    def get_storage_nqn_info(self):
        flag = self.get_storage_nvme_initiator()
        if not flag:
            self.result['result'] = "False"
            return True, json.dumps(self.result)
        if len(self.result.get("nvme_initiator")) == 0:
            self.logger.info("[get_nvme_num]the nqn num is 0.")
            self.result['result'] = "True"
            return True, json.dumps(self.result)
        return False, json.dumps(self.result)
