# -*- coding: UTF-8 -*-

from function import StorageContextUtil
from function import StorageResource

from cbb.common.query.software import cliUtil
from java.lang import Exception as JException

import json


def execute(context):
    '''
    @summary: 入口程序 执行自定义命令并保存回显
    @param context: 上下文对象
    '''

    logger = StorageContextUtil.getLogger(context)
    lang = StorageContextUtil.getLang(context)

    try:
        storage_host_executer = StorageHostExecuter(context)
        logger.error("[savehostinfowwnsCustom] storage_host_executer.get_host_ostype_wwn() start")
        flag, storage_host_os_wwns_str = \
            storage_host_executer.get_host_ostype_wwn()

        dev_sn = StorageContextUtil.getDevSN(context)
        _save_device_info(context, "{}_storageHostOsWwnsInfo".format(dev_sn), storage_host_os_wwns_str)
        return True, ""
    except (Exception, JException) as e:
        logger.error("[savehostinfowwnsCustom] error: {}".format(str(e)))
        return False, StorageResource.getMsg(lang, "query.result.abnormal")


def _save_device_info(context, item, save_info):
    '''
    @summary: 保存相关的设备信息
    @param context: 上下文对象
    '''
    logger = StorageContextUtil.getLogger(context)
    scene_data_instance = StorageContextUtil.getSceneDataExchangeObj(context)
    logger.info("[_saveDeviceInfo] save item: {}".format(item))
    scene_data_instance.saveKV(item, save_info)


class StorageHostExecuter():
    """
    查询阵列侧的所有主机、及影响的启动器,及操作系统类型
    返回的json数据格式如下：
    {
    "failCommand":[],
    "cliRets": "",
    "host_os_wwninfo": []
    }
    """

    def __init__(self, context):
        self.context = context
        self.logger = StorageContextUtil.getLogger(context)
        self.lang = StorageContextUtil.getLang(context)
        self.cli = StorageContextUtil.getSSH(context)
        self.result = dict(failCommand=[],
                           cliRets="", result="nocheck", host_os_wwninfo={})

    def append_cli_rets(self, cli_ret):
        all_cli_rets = self.result.get("cliRets")
        all_cli_rets += cli_ret + "\n"
        self.result["cliRets"] = all_cli_rets

    def get_hostinfo(self):
        self.logger.info("[get_hostinfo] get hostinfo start.")
        flag, cli_ret, err_msg, hostInfo = cliUtil.get_host_dict(self.cli, self.lang)
        self.append_cli_rets(cli_ret)
        if flag is not True:
            self.logger.error("[get_hostinfo] get hostinfo error msg:{}".format(err_msg))
            self.result["failCommand"] = "show host general"
            return False, hostInfo
        return True, hostInfo

    def get_host_initiator_fc_wwn(self, hostId):
        wwns = []
        flag, cli_ret, errMsg, initiators = cliUtil.get_host_initiator_fc(self.cli, self.lang, hostId)
        self.append_cli_rets(cli_ret)
        if flag is not True:
            self.logger.error("[get_host_initiator] get host initiator fc error msg:{}".format(errMsg))
            self.result["failCommand"] = "show initiator initiator_type=FC host_id={}".format(hostId)
            return False, wwns
        for initiatorinfo in initiators:
            wwn = initiatorinfo.get("WWN")
            wwns.append(wwn)
        return True, wwns

    def get_host_initiator_iSCSI_wwn(self, hostId):
        wwns = []
        flag, cli_ret, errMsg, initiators = cliUtil.get_host_initiator_iSCSI(self.cli, self.lang, hostId)
        self.append_cli_rets(cli_ret)
        if flag is not True:
            self.logger.error("[get_host_initiator] get host initiator iSCSI error msg:{}".formate(errMsg))
            self.result["failCommand"] = "show initiator initiator_type=iSCSI host_id={}".format(hostId)
            return False, wwns
        for initiatorinfo in initiators:
            wwn = initiatorinfo.get("iSCSI IQN")
            wwns.append(wwn)
        return True, wwns

    def get_host_initiator_ib_wwn(self, hostId):
        wwns = []
        flag, cli_ret, errMsg, initiators = cliUtil.get_host_initiator_ib(self.cli, self.lang, hostId)
        self.append_cli_rets(cli_ret)
        if flag is not True:
            self.logger.error("[get_host_initiator] get host initiator error msg:{}".format(errMsg))
            self.result["failCommand"] = "show ib_initiator general host_id={}".format(hostId)
            return False, wwns
        for initiatorinfo in initiators:
            wwn = initiatorinfo.get("WWN")
            wwns.append(wwn)
        return True, wwns

    def get_host_initiator_wwn(self, hostId):
        wwns = []
        fc_flag, fc_wwns = self.get_host_initiator_fc_wwn(hostId)
        if fc_flag:
            for fcwwn in fc_wwns:
                wwns.append(fcwwn)
        iscsi_flag, iscsi_wwns = self.get_host_initiator_iSCSI_wwn(hostId)
        if iscsi_flag:
            for iscsi_wwn in iscsi_wwns:
                wwns.append(iscsi_wwn)
        ib_flag, ib_wwns = self.get_host_initiator_ib_wwn(hostId)
        if ib_flag:
            for ib_wwn in ib_wwns:
                wwns.append(ib_wwn)
        if fc_flag or iscsi_flag or ib_flag:
            return False, wwns
        return True, wwns

    def get_host_ostype_wwn(self):
        flag, hostInfo = self.get_hostinfo()
        if not flag:
            self.result['result'] = "False"
        hostwwninfo = self.get_host_wwninfo(hostInfo)
        self.result['result'] = "True"
        self.result['host_os_wwninfo'] = hostwwninfo
        return True, json.dumps(self.result)

    def get_host_wwninfo(self, hostInfo):
        hostwwninfo = {}
        for item in hostInfo.items():
            hostId = item[0]
            info = item[1]
            ostype = info.get("Operating System")
            result, wwns = self.get_host_initiator_wwn(hostId)
            if not result:
                self.result['result'] = "False"
            for wwn in wwns:
                hostwwninfo[wwn] = "{}*{}".format(hostId, ostype)
        return hostwwninfo
