# -*- coding: UTF-8 -*-
from frameone.util import baseUtil, contextUtil


class ResourceType():
    """
    功能描述：接口类型。
    """
    REST = "restImpl"
    TLV = "tlvImpl"


class ResourceSelector():
    """
    功能描述：接口类型选择器。
    """

    def __init__(self, context):
        self.logger = contextUtil.getLogger(context)
        self.devVersion = contextUtil.getCurVersion(context)
        self.devType = contextUtil.getDevType(context)

    def commonSelector(self):
        self.logger.info("commonSelector devType=%s, devVersion=%s" % (self.devType, self.devVersion))
        if baseUtil.isSupportRest(self.devType, self.devVersion):
            self.logger.info("user rest adapter.")
            return ResourceType.REST
        else:
            self.logger.info("user tlv adapter.")
            return ResourceType.TLV

    def hostLinkSelector(self):
        if baseUtil.isSupportRest(self.devType, self.devVersion):
            return ResourceType.REST
        else:
            return ResourceType.TLV
