# -*- coding: UTF-8 -*-
import time
import traceback
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from java.lang import Exception as JException
from com.huawei.ism.exception import IsmException
from frameone.tlv import tlvUtil
from frameone.base import config
from frameone.util import baseUtil,contextUtil
from frameone.tlv.tlvEnumFactory import TlvEnum
from frameone.tlv.tlvFactory import Tlv
from frameone.base.exception import TlvCmdException, ErrorCodeSet, ErrorCode

def transException(fn):
    '''
    将ISM异常转换为CliCmdException
    restUtil中的execCmd：
        抛出Exception异常
        CommonRest.REST_CAN_NOT_EXECUTE--
        若response中错误码不为0，则将错误码转为异常抛出
        自带3次重试
    '''
    def inner(*params):
        self = params[0]
        try:
            return fn(*params)
        except:
            try:
                return fn(*params)
            except:
                self.logger.error("java excption:%s" % traceback.format_exc())
            raise TlvCmdException(ErrorCode(ErrorCodeSet.TLV_CONNECTION_EXCEPTION))
    return inner


"""
    执行升级前后检查
"""
CMD_DEFAULT_TIMEOUT = 300

class TlvService:
    def __init__(self, dataDict):
        self.dataDict = dataDict
        self.logger = dataDict.get('logger')

    def getHostLink(self, hostId):
        allDatas = []
        for initiatorType in [223, 222, 16499]:
            param0 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['parentType'], Tlv.Param.TYPE_ENUM, 21)
            param1 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['parentID'], Tlv.Param.TYPE_STR, hostId)
            param2 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['initiator_type'], Tlv.Param.TYPE_ENUM, initiatorType)
            param3 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['type'], Tlv.Param.TYPE_ENUM, 255)
            paramlist = Tlv.Param.getParamList(param3, param0, param1, param2)
            try:
                tlv = contextUtil.getTlvObj(self.dataDict)
                recs = tlvUtil.execCmd(tlv, TlvEnum.cmd["GET_BATCH_NEXT"], paramlist, getBatch=True, timeOut=CMD_DEFAULT_TIMEOUT)
                if recs:
                    allDatas.extend(recs)
            except IsmException, e:
                if e.getErrorId() in [50331651]:
                    self.logger.info("cannot support initiatorType=%s" % initiatorType)
        return allDatas


    def getHostLinkByType(self, hostId, type):
        allDatas = []
        InitiatorTypeDict = dict(FC=223, ISCSI=222, IB=16499)
        initiatorType = InitiatorTypeDict.get(type.upper())
        param0 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['parentType'], Tlv.Param.TYPE_ENUM, 21)
        param1 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['parentID'], Tlv.Param.TYPE_STR, hostId)
        param2 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['initiator_type'], Tlv.Param.TYPE_ENUM,
                                    initiatorType)
        param3 = Tlv.Param.getParam(TlvEnum.PoolLunMap.HOST_LINK['type'], Tlv.Param.TYPE_ENUM, 255)
        paramlist = Tlv.Param.getParamList(param3, param0, param1, param2)
        try:
            tlv = contextUtil.getTlvObj(self.dataDict)
            recs = tlvUtil.execCmd(tlv, TlvEnum.cmd["GET_BATCH_NEXT"], paramlist, getBatch=True,
                                   timeOut=CMD_DEFAULT_TIMEOUT)
            self.logger.info("getHostLinkByType recs=%s" % recs)
            if recs:
                allDatas.extend(recs)
        except IsmException, e:
            if e.getErrorId() in [50331651]:
                self.logger.info("cannot support initiatorType=%s" % initiatorType)
        return allDatas

    @transException
    def excuteDiagnoseCmd(self, command, locationId):
        msgParam0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(0))
        msgParam1 = Param(1, ParamType.STRING, "")
        msgParam2 = Param(2, ParamType.UNSIGN_INT, UnsignedInt32(0))
        msgParam3 = Param(3, ParamType.STRING, "")
        msgParam4 = Param(4, ParamType.STRING, "")
        msgParam5 = Param(5, ParamType.STRING, "")
        msgParam6 = Param(6, ParamType.STRING, "")
        msgParam7 = Param(7, ParamType.STRING, "")
        msgParam8 = Param(8, ParamType.STRING, "")
        msgParam9 = Param(9, ParamType.UNSIGN_INT, UnsignedInt32(1))
        msgParam12 = Param(12, ParamType.STRING, command)
        msgParam13 = Param(13, ParamType.UNSIGN_INT, UnsignedInt32(locationId))
        params = TLVUtils.paramList(msgParam0, msgParam1, msgParam2, msgParam3, msgParam4, msgParam5, msgParam6,
                                    msgParam7,
                                    msgParam8, msgParam9, msgParam12, msgParam13)
        self.logger.info('Execute cmd [code:%d] [%s]' % (CommandConstans.EXC_UPD, params))
        tlv = contextUtil.getTlvObj(self.dataDict)
        recs = tlvUtil.execCmd(tlv, TlvEnum.cmd["OM_MSG_OP_UPD_EXECUTE"], params, getBatch=True,
                               timeOut=CMD_DEFAULT_TIMEOUT)

        return recs

    @transException
    def getParamStrValue(self, rec, index):
        return rec.getParamStrValue(index)

    @transException
    def getParamIntValue(self, rec, index):
        return rec.getParamIntValue(index).intValue()



