# -*- coding: UTF-8 -*-
# 该配置脚本只在frame框架中使用

HVS_DEVS = ["18500", "18800", "HVS85T", "HVS88T", "18800F"]
HIGH_END_DEVS = ["18500 V3", "18800 V3", "18500 V5", "18800 V5","18500F V3", "18800F V3", "18500F V5", "18800F V5"]
ARM_DEVS = ["2200 V3", "2600 V3", "5100 V3", "2600 V3 for Video"]
ARM_DEVS_2U = ["2200 V3", "2600 V3", "2600 V3 for Video"]
DORADO_DEVS = ["Dorado3000 V3", "Dorado5000 V3", "Dorado6000 V3", "Dorado18000 V3"]
DORADO_NAS_DEVS = ["Dorado NAS"]
CTRL_6U_PRODUCTS = ["6800 V3", "18500 V3", "18800 V3"]
SVP_REST_IP = '172.17.126.11'
HVS_REST_IP = '127.0.0.1'

MEMORY_DEVS_180 = ["2100 V3", "2200 V3", "2200 V3 Enhanced", "2600 V3 Enhanced", "2600 V3", "2600F V3",
                   "2600F V3 Enhanced", "2600 V3 for Video", "2800 V3", "2800 V5", "5100 V3", "5300 V3",
                   "5300 V5", "5300F V5", "5300 V5 Enhanced"]
MEMORY_DEVS_200 = ["S2600T", "S5500T", "5500 V3", "5500 V5", "5500 V5 Elite", "5500F V3", "5500F V5"]
MEMORY_DEVS_270 = ["5600 V3", "5600F V3", "5600 V5", "5600F V5", "5800 V3", "5800F V3",
                   "5800 V5", "5800F V5", "6800 V3", "6800F V3", "6800 V5", "6800F V5"]
MEMORY_DEVS_400 = ["18500 V3", "18500F V3", "18500 V5", "18500F V5", "18800 V3", "18800F V3",
                   "18800 V5", "18800F V5"]

REST_BASE_URI = r"https://%s:%s/deviceManager/rest/%s/"
REST_DEFAULT_PORT = "8088"
REST_DEFAULT_RETRY_TIMES = 3  # 重试次数
REST_DEFAULT_TIMEOUT = 120  # 默认超时时间
REST_RECORD_MAXNUM = 100  # TLV执行批量查询时的最大条数（自选）

RETRY_TIMES = 3  # rest重试次数
ERR_CODE_SLAVE_NODE_HANDLE_MSG_IGNORE = "1089101853"
REST_DEFAULT_ERR_CODE = "0"
ERR_CODE_FILE_NOT_EXIST = "50334237"  # 若返回的错误信息包含license，则说明该文件不存在；否则继续抛出异常
ERR_CODE_CMD_TIME_OUT = "16797698"  # 命令下发超时。/Executing command time out. 通信异常或系统繁忙。/The communication is abnormal or the system is busy.
ERR_CODE_NOT_EXIST = "1077948996"  # 删除、修改对象时检测到对象不存在 原因: 指定的对象不存在。
ERR_CODE_COMMUNICATION_ABNORMAL = "1073949185"  # connector与阵列之间网络通信异常。The connector failed to connect to the arrays.  原因：与设备通信异常。建议：请检查网络连接或设备状态是否正常。
ERR_CODE_CMD_NOT_SUPPORTED = "1077949002"  # 网管消息中命令字未注册，非法命令字 原因: 系统不支持此操作。 建议: 请联系技术支持工程师。
ERR_CODE_PAGES_FAILED = "1073794887"  # 在离线系统业务时，Cache中存在失效页面，导致业务无法离线。
ERR_CODE_OFF_OFFLINE_FAILED = "1073794888"  # 在离线系统业务时，系统存在故障，导致业务离线失败。
ERR_CODE_SYSTEM_BUSY = "1077949006"  # 系统繁忙请稍后重试
ERR_CODE_CAN_NOT_EXECUTE = "1077936891"  # 支持包脚本文件异常，执行查询支持包命令执行失败。
ERR_CODE_NORMAL = "0"  # 默认正常的返回值
ERR_CODE_ABEND = "9999900001"  # 自定义Rest下发命令后返回异常,不支持该命令
ERR_CODE_ENGINE_CAN_NOT_MONITOR = ["1077949083"]  # 引擎无法监控，导致系统软件工作异常，禁止配置
ERR_CODE_UPGRADE_ERROR_CODE = "1077949021"  # 系统正在升级时，不能配置业务。
ERR_CODE_FAIL_COMMUNICATION = [
    "16797697",  # 与设备断开连接
    ERR_CODE_COMMUNICATION_ABNORMAL,  # 与设备通信异常，请检查网络连接或设备状态是否正常
    ERR_CODE_CMD_TIME_OUT,  # 命令下发超时
]

CONTROLLER_PAIR = {
    "A": "B",
    "B": "A",
    "C": "D",
    "D": "C",
}

NODE_ID_MAP = {
    "A": 0,
    "B": 1,
    "C": 2,
    "D": 3,
}
# 检查业务压力相关参数
CHECK_SYS_PRESSURE_PERIOD = 1  # 检查周期（秒）
CHECK_SYS_PRESSURE_TIMES = 30  # 检查业务压力的总次数
CHECK_SUCCESS_RATE = 0.3  # 检查成功达标率
MAX_CPUUSAGE_PER_CTRL = 40  # 单个控制器允许最大CPU利用率

g_frontEndIntfModels = (  # 所有的前端接口model
    1,  # 4x4G FC接口模块
    2,  # 2x4G FC接口模块
    3,  # 2xGE 电接口模块
    5,  # Swapped FC接口模块
    6,  # 2x10GE 光接口模块
    7,  # 1x8G FC光接口模块
    8,  # 2x8G FC光接口模块
    11,  # 2xFC+2xGE 接口模块
    12,  # 4xGE 电接口模块
    13,  # 4x8G FC光接口模块
    21,  # 4x10G FCoE光接口模块
    25,  # 4x10GE接口模块
    27,  # 2x10G FCoE光接口模块
    28,  # 4xGE光接口模块
    29,  # 2x16G FC光接口模块
    31,  # 4x10GE 电接口模块
    32,  # 2x40GE IB接口模块
    33,  # 2x56GE IB接口模块
    34,  # 4xGE 电接口模块
    36,  # 4x10GE 电接口模块
    37,  # 4xSmart 光接口模块
    38,  # 8x8G FC光接口模块
    39,  # 4x8G FC光接口卡
    40  # 4x16G FC光接口卡
)


class IpTypeEnum():
    IPV4 = 0
    IPV6 = 1


# 超时时间配置
REBOOT_CONTROLLER_TIME_OUT = 5 * 60  # 重启控制器
CHECK_POWERON_TIME_OUT = 30 * 60  # 检查重启上电
CHECK_BUSINESS_STATUS_TIME_OUT = 90 * 60  # 检查业务恢复
OFFLINE_CTRL_TIMEOUT = 300  # 离线控制器超时
OFFLINE_SINGLE_CTRL_TIMEOUT = 900  # 离线轮训检查时间,停虚拟机5分钟，下电10分钟。
OFFLINE_CTRL_INTERVAL = 5

SERIES_T = "T_SERIES"
SERIES_V3 = "V3_SERIES"
SERIES_ARM = "ARM_SERIES"
SERIES_Dorado = "Dorado_SERIES"
SERIES_18000V3 = "18000V3_SERIES"
SERIES_18000 = "18000_SERIES"
SERIES_68V5 = "68V5_SERIES"

STOR_DEV_INFO_DICT = {
    "S2600T": SERIES_T,
    "S5500T": SERIES_T,
    "S5600T": SERIES_T,
    "S5800T": SERIES_T,
    "S6800T": SERIES_T,
    "2200 V3": SERIES_ARM,
    "2600 V3": SERIES_ARM,
    "2600 V3 for Video": SERIES_ARM,
    "2600F V3": SERIES_ARM,
    "2800 V3": SERIES_V3,
    "5300 V3": SERIES_V3,
    "5500 V3": SERIES_V3,
    "5500F V3": SERIES_V3,
    "5600 V3": SERIES_V3,
    "5600F V3": SERIES_V3,
    "5800 V3": SERIES_V3,
    "5800F V3": SERIES_V3,
    "6800 V3": SERIES_V3,
    "6800F V3": SERIES_V3,
    "6900 V3": SERIES_V3,
    "2800 V5": SERIES_V3,
    "5110 V5": SERIES_ARM,
    "5100K V5": SERIES_ARM,
    "5110F V5":SERIES_ARM,
    "5210 V5":SERIES_ARM,
    "5200K V5": SERIES_ARM,
    "5210F V5":SERIES_ARM,
    "5300 V5": SERIES_ARM,
    "5500 V5": SERIES_V3,
    "5600 V5": SERIES_V3,
    "5800 V5": SERIES_V3,
    "6800 V5": SERIES_68V5,
    "5300F V5": SERIES_V3,
    "5500F V5": SERIES_V3,
    "5600F V5": SERIES_V3,
    "5800F V5": SERIES_V3,
    "6800F V5": SERIES_68V5,
    'Dorado3000 V3': SERIES_Dorado,
    'Dorado5000 V3': SERIES_Dorado,
    'Dorado6000 V3': SERIES_Dorado,
    "HVS85T": SERIES_18000,
    "HVS88T": SERIES_18000,
    "18500": SERIES_18000,
    "18800": SERIES_18000,
    "18800F": SERIES_18000,
    "18500 V3": SERIES_18000V3,
    "18500F V3": SERIES_18000V3,
    "18800 V3": SERIES_18000V3,
    "18800F V3": SERIES_18000V3,
    "18500 V5": SERIES_18000V3,
    "18800 V5": SERIES_18000V3,
    "18500F V5": SERIES_18000V3,
    "18800F V5": SERIES_18000V3,
}
