# -*- coding: UTF-8 -*-
import traceback
import sys
import os
from cbb.frame.util.common import wrapAllExceptionLogged

def format_traceback():
    new_extracted_list = []
    etype, value, tb = sys.exc_info()
    extracted_list = traceback.extract_tb(tb)
    for item in extracted_list:
        filename, lineno, name, line = item
        filename = os.path.basename(filename)
        new_extracted_list.append((filename, lineno, name, line))
        
    return "".join(traceback.format_list(new_extracted_list) + traceback.format_exception_only(etype, value))

class Logger(object):
    '''
    @summary 日志类
    '''
    def __init__(self, loggerInstance, pyFileName):
        self.loggerInstance = loggerInstance
        self.pyFileName = pyFileName

    @wrapAllExceptionLogged(logger=None)
    def debug(self, msg):
        '''
        @summary: 调试信息输出
        @param msg: 调试信息
        '''
        if msg is None:
            msg = "None"
        self.loggerInstance.debug(msg)

    def info(self, msg):
        '''
        @summary: 调试信息输出
        @param msg: 调试信息
        '''
        if msg is None:
            msg = "None"
        self.debug("[ToolLog][%s][info][%s]" % (self.pyFileName, str(msg)))
        return

    def error(self, msg):
        '''
        @summary: 检查异常时的输出
        @param exception: 异常消息
        '''
        trace = format_traceback()
        self.debug("[ToolLog][%s][error][%s][traceback:%s]" % (self.pyFileName, msg, trace))
        return
