﻿# -*- coding: UTF-8 -*-
import traceback
from frameone.util import baseUtil
from frameone.util import jsonUtil
from javax.net.ssl import SSLException
from java.lang import Exception as JException

class RestConnection(object):
    AUTHENTICATE_URI = r"https://%s:%s/deviceManager/rest/%s/sessions"
    REST_BASE_URI = r"https://%s:%s/deviceManager/rest/%s/"
    RE_CONNECTION_TIMES = 3
    PROXY_OF_SVP_CONNECTION_TIMES = 2
    REST_PORT_DEFAULT = 8088
    REST_SCOPE_DEFAULT = "0"
    REST_CAN_NOT_CONNECT_CODE = "1073949185" #与设备通信异常，请检查网络连接或设备状态是否正常
    _instance = None
    _rest = None
       
    def __new__(cls, *args, **kwargs):
        if cls._instance is None:
            cls._instance = super(RestConnection, cls).__new__(cls, *args, **kwargs)
        return cls._instance
    
    def __init__(self, connectorFactory, ip, devSN, restPort = REST_PORT_DEFAULT):
        self.connectorFactory = connectorFactory
        self.ip = ip
        self.restPort = restPort
        self.devSN = devSN
        self.baseUri = self.REST_BASE_URI % (self.getUrlIp(ip), str(restPort), str(devSN))
        self.loginUri = self.AUTHENTICATE_URI % (self.getUrlIp(ip), str(restPort), str(devSN))
        self._rest = None

    def setContext(self, context):
        self.context = context
        self.logger = context.get("logger")

    def create(self, user, pawd, scope = REST_SCOPE_DEFAULT):
        """
        @summary: 创建rest连接
        @param user: 用户名
        @param pawd: 密码
        @param scope: 用户类型
        @return: 
            True:建立成功
            False:建立失败   
        """
        successFlag = self.createInner(user, pawd, scope)
        devType = self.context.get("dev").getDeviceModel()
        if not successFlag and baseUtil.isHvsDev(devType):
            portStr = ":" + str(self.restPort)
            self.logger.info("begin to try default port create rest connection.")
            self.loginUri = self.loginUri.replace(portStr, "")
            self.baseUri = self.baseUri.replace(portStr, "")
            successFlag = self.createInner(user, pawd, scope)

        del pawd
        if not successFlag:
            raise Exception(self.REST_CAN_NOT_CONNECT_CODE)
        return successFlag

    def createInner(self, user, pawd, scope = REST_SCOPE_DEFAULT):
        reConnectionTimes = 0
        successFlag = False
        while self._rest is None and reConnectionTimes < \
                RestConnection.RE_CONNECTION_TIMES + RestConnection.PROXY_OF_SVP_CONNECTION_TIMES:
            try:
                restConnector = self.connectorFactory.createRestConnector(self.loginUri, user, pawd, scope)
                restConnection = restConnector.getConnection()
                if reConnectionTimes % 2 == 0:
                    content = restConnection.login().getContent()
                else:
                    login_result = restConnection.loginSvpProxy()
                    if login_result:
                        content = login_result.getContent()
                    else:
                        reConnectionTimes += 1
                        continue
                responseInfo = jsonUtil.jsonStr2Dict(content)
                data = responseInfo["data"]
                iBaseToken = data.get("iBaseToken", None)
                if iBaseToken is not None:
                    successFlag = True
                    self._rest = restConnection
                    break
                reConnectionTimes += 1
            except (Exception, JException) as e:
                self.logger.error("create rest connection excption[%s]" % traceback)
                reConnectionTimes += 1
        return successFlag


    def close(self):
        if self._rest is not None:
            try:
                self._rest.closeSession()
            except:
                return
            finally:
                self._rest = None
        return
    
    def getRestConnection(self, user, pawd, scope):
        try:
            if self._rest is None or not self.checkConnetionNormal():
                self._rest = None
                self.create(user, pawd, scope)
        except Exception,e:
            raise Exception(self.REST_CAN_NOT_CONNECT_CODE, unicode(e))
        
        return self._rest
    
    def getBaseUri(self):
        return self.baseUri
    
    def getRest(self):
        return self._rest

    def checkConnetionNormal(self):
        uri = self.baseUri + "system/"
        paramsStr = ""
        try:
            records = jsonUtil.jsonStr2Dict(self._rest.execGet(uri, paramsStr).getContent())
            data = records["data"]
            return "HEALTHSTATUS" in data.keys()
        except:
            return False
    
    def getUrlIp(self,ip):
        if ":" in str(ip):
            return "[%s]" % str(ip)
        return str(ip)