# -*- coding: UTF-8 -*-

from frameone.cli import cliUtil
from frameone.util import contextUtil
from com.huawei.ism.exception import IsmException  # IGNORE:F0401 #PyLint中引用会报错，但实际可引用，故屏蔽
from java.lang import Exception as JException
from com.huawei.ism.tlv import TLVUtils  # IGNORE:F0401 #PyLint中引用会报错，但实际可引用，故屏蔽
from com.huawei.ism.tlv.bean import Param  # IGNORE:F0401 #PyLint中引用会报错，但实际可引用，故屏蔽
from com.huawei.ism.tlv.docoder import ParamType  # IGNORE:F0401 #PyLint中引用会报错，但实际可引用，故屏蔽
from com.huawei.ism.tlv.lang import UnsignedInt32  # IGNORE:F0401 #PyLint中引用会报错，但实际可引用，故屏蔽
from com.huawei.ism.tool.framework.platform.exception import ToolException  # IGNORE:F0401 #PyLint中引用会报错，但实际可引用，故屏蔽
from java.lang import String  # @UnresolvedImport
from java.util import ArrayList as JavaList  # @UnresolvedImport #JavaList可用，故屏蔽PyDev报错;

from frameone.tlv.tlvEnumFactory import *

TLV_CAN_NOT_EXECUTE = "1077936892" #命令执行失败
#Tlv执行类：已剥离与设备相关的枚举信息
class Tlv():
    
    ________TEST_ZONE________ = None
    
    '''
    Function: 模块测试入口，供TestFactory调用
    '''
    @staticmethod
    def testEntrance(context):
        log.debug(context, "enter sub test function.")
        
        return
    
    ________FUNC_ZONE________ = None
    
    
    '''
    Function: 使用getBatch接口执行TLV命令
    Params:
        context：上下文对象，内含TLV连接创建方法和参数
        cmdType：具体的TLV命令，参见TlvEnumFactory中的字典Cmd
        paramList：参数列表
    Return: 命令执行结果
    '''
    @staticmethod
    def getBatch(context, cmdType, paramList, logCmdResult=True):
        #创建TLV连接
        tlvConn = Tlv.Conn.getConn(context)
        if None == tlvConn:
            return None
        
        #执行TLV命令
        try:
            #1 打印命令类型和查询的对象类型，方便问题定位
            #获取查询对象的编号
            queryObjinfo=""
            objType = None
            paramNum = paramList.size()
            for index in range(0, paramNum): #获取type参数的值
                if TlvEnum.pubAttr["type"] == paramList.get(index).getIndex():
                    objType = paramList.get(index).getValue()
            #构造查询对象的描述
            objType = str(objType)
            log.info(context, "TLV_CMD_INFO(getBatch): cmdType=" + str(cmdType) + ", paramList=" + str(paramList))
            
            #2 执行命令获取执行结果
            recs = None
            '''
            Question：增加getBatch的批量查询接口
            Date & Reason: 2014-04-24 & bictchNext通过多次调用getBatch来实现，但其仅考虑了ID为STR的情况，对于ID为INT的批量查询，则会因转换错误而抛出异常。
                getBatch一次查询，可获得100条左右信息，对通常的批量查询已能满足。但对于其他非正规的批量（大批量）查询命令，可通过该命令的组合来实现。
            '''
            recs = tlvConn.getBatch(cmdType, paramList, Tlv.Const.TIMEOUT_DEFAULT)
            if True == logCmdResult:
                Tlv.Record.logRecList(context, recs, "TLV_CMD_RESULT getBatch as follows:")
            else:
                log.info(context, "TLV_CMD_RESULT getBatch is ignored.")
            #如果recs的最后一行为结束标识行，则清除它
            if None != recs and 0 < recs.size():
                tailRec = recs.get(recs.size()-1)
                if tailRec.getParams().size() == 0:
                    raise exception.newToolException(u"未处理的异常：TLV命令执行结果为空。", 
                            const.HELP_DESC_ZH,
                            "Unprocessed exception: the executed result of TLV command is empty.",
                            const.HELP_DESC_EN, 
                            Tlv.Const.ERRID_EMPTY_RESULT)
                headIndex0 = tailRec.getParams().get(0).getIndex()
                headIndex1 = ""
                log.info(context, "tailRec.getParams=%s" % tailRec.getParams())
                if tailRec.getParams().size() > 1:
                    headIndex1 = tailRec.getParams().get(1).getIndex()
                if Tlv.Const.RECORD_ENDFLAG in [headIndex0, headIndex1]:
                    log.info(context, "remove the last useless record: " + str(tailRec))
                    recs.remove(recs.size()-1)
            
            #3 返回结果
            if None == recs: #为None的话，只可能为程序异常所致，直接抛出异常。
                raise exception.newToolException(u"TLV命令执行结果为None。", 
                            const.HELP_DESC_ZH,
                            "The executed result of TLV command is None.",
                            const.HELP_DESC_EN,
                            Tlv.Const.ERRID_NONE_RESULT)
            return recs
        
        except IsmException, ex:
            log.error(context, "An ISM exception occured when exec Tlv.execmd.")
            #抛出异常
            errCode = ex.getErrorId()
            errMsg = ex.getErrorMessage()
            errMsg = errMsg.rstrip(u"。").rstrip(".")
            log.info(context, "exception info: " + str(ex))
            raise exception.newToolException(u"TLV命令执行失败。原因为" + errMsg + u"。", 
                            u"请检查网络连接或设备状态是否正常。",
                            "Failed to execute the TLV command. Cause is " + errMsg + ".",
                            "Retry when the network and device are normal.", errCode)
                        
        except ToolException, et:
            #记录错误并直接抛出异常
            log.error(context, "An ToolException [%s] occured when exec Tlv.execmd:" % et)
            raise exception.getToolExceptionByErrId(et)
        
        except Exception, e:
            log.error(context, "An tool exception occured when exec Tlv.execmd:" + str(e))
            #抛出异常
            if len(e.args) >= len(exception.argsId) and \
                (Tlv.Const.ERRID_EMPTY_RESULT == e.args[exception.argsId["ERRID"]] or \
                 Tlv.Const.ERRID_NONE_RESULT == e.args[exception.argsId["ERRID"]]):
                raise e
            else:
                raise exception.newToolException(u"TLV命令执行失败。", 
                                const.HELP_DESC_ZH,
                                "Failed to execute the TLV command.",
                                const.HELP_DESC_EN)
            

    '''
    Function: 执行TLV命令
    Params:
        context：上下文对象，内含TLV连接创建方法和参数
        isBatch：返回结果是否为多条记录。True=是；False=否
        cmdType：具体的TLV命令，参见TlvEnumFactory中的字典Cmd
        paramList：参数列表
    Return: 命令执行结果
    '''
    @staticmethod
    def execmd(context, isBatch, cmdType, paramList, logCmdResult=True, isExecCmdToSvp=False):
        #创建TLV连接
        if isExecCmdToSvp:
            tlvConn = Tlv.Conn.getTlvConnectionSVP(context)
        else:
            tlvConn = Tlv.Conn.getConn(context)
            
        if tlvConn is None:
            return None
        
        #执行TLV命令
        try:
            #1 打印命令类型和查询的对象类型，方便问题定位
            #获取查询对象的编号
            objType = None
            paramNum = paramList.size()
            for index in range(0, paramNum): #获取type参数的值
                if TlvEnum.pubAttr["type"] == paramList.get(index).getIndex():
                    objType = paramList.get(index).getValue()
            #构造查询对象的描述
            objType = str(objType)
            #记录命令信息
            log.info(context, "TLV_CMD_INFO: cmdType=" + str(cmdType) + ", paramList=" + str(paramList))
            
            #2 执行命令获取执行结果
            recs = None
            #按isBatch调用不同的TLV接口
            if True == isBatch:
                '''
                Question：将tlv连接中的命令执行接口，由getBatch换成bacthNext
                Date & Reason: 2014-02-22 & getBatch在实现上仅下发了GET_BATCH_NEXT命令，
                                                        由于获取批量信息的TLV命令机制限制，该命令在有些情况下不会返回所有的信息，如获取所有控制器信息；
                                                        采用bacthNext后，该函数会预先执行一次getBatch，然后按返回情况来判断获取的信息是否完整，并在不完整时循环获取剩余信息，
                                                        从而最终返回所有类似的信息。
                '''
                recs = tlvConn.getBatch(cmdType, paramList, Tlv.Const.TIMEOUT_DEFAULT)
                if True == logCmdResult:
                    Tlv.Record.logRecList(context, recs, "TLV_CMD_RESULT bacthNext as follows:")
                else:
                    log.info(context, "TLV_CMD_RESULT bacthNext is ignored.")
                #如果recs的最后一行为结束标识行，则清除它
                if recs is not None and recs.size() > 0:
                    tailRec = recs.get(recs.size()-1)
                    if tailRec.getParams().size() == 0:
                        raise
                    headIndex = tailRec.getParams().get(0).getIndex()
                    headIndex1 = ""
                    log.info(context, "tailRec.getParams=%s" % tailRec.getParams())
                    if tailRec.getParams().size() > 1:
                        headIndex1 = tailRec.getParams().get(1).getIndex()
                    if Tlv.Const.RECORD_ENDFLAG in [headIndex, headIndex1]:
                        log.info(context, "remove the last useless record: " + str(tailRec))
                        recs.remove(recs.size()-1)
            else:
                recs = tlvConn.invoke(cmdType, paramList, Tlv.Const.TIMEOUT_DEFAULT)
                log.info(context, "TLV_CMD_RESULT invoke: " + str(recs))
            
            #3 返回结果
            if recs is None: #为None的话，只可能为程序异常所致，直接抛出异常。
                raise
            return recs
        
        except IsmException, ex:
            log.error(context, "An ISM exception occured when exec Tlv.execmd.")
            raise ex
        except (Exception, JException), e:
            raise IsmException(int(TLV_CAN_NOT_EXECUTE), e)

    '''
    TLV参数构造类
    '''
    class Param():
        '''
        TLV参数类型
        '''
        TYPE_UINT = 0   #无符号整形
        TYPE_STR  = 1   #字符串
        TYPE_ENUM = 2   #枚举(Fru的type字段需用这种类型)
        
        '''
        Function: 生成一个TLV参数
        Params: index=参数在命令中的位置；type=TLV参数类型；value=TLV参数值
        Return: TLV参数对象
        '''
        @staticmethod
        def getParam(index, type, value):
            #参数校验
            if index < 0:
                return None
            if type != Tlv.Param.TYPE_UINT \
                and type != Tlv.Param.TYPE_STR \
                 and type != Tlv.Param.TYPE_ENUM:
                return None
            #生成参数
            param = None
            if type == Tlv.Param.TYPE_UINT:
                param = Param(index, ParamType.UNSIGN_INT, UnsignedInt32(value)) #@UndefinedVariable #UNSIGN_INT存在，故屏蔽PyDev报错
            elif type == Tlv.Param.TYPE_STR:
                param = Param(index, ParamType.STRING, str(value)) #@UndefinedVariable #STRING存在，故屏蔽PyDev报错
            elif type == Tlv.Param.TYPE_ENUM:
                param = Param(index, ParamType.ENUM, UnsignedInt32(value)) #@UndefinedVariable #ENUM存在，故屏蔽PyDev报错
            #返回参数
            return param
        
        '''
        Function: 生成TLV参数列表
        Params: allParam=所有的TLV参数，中间以逗号隔开
        Return: TLV参数列表
        '''
        @staticmethod
        def getParamList(*allParam):
            paramList = []
            for param in allParam:
                paramList.append(param)
            return TLVUtils.paramList(paramList) #@UndefinedVariable #paramList存在，故屏蔽PyDev报错
        
        
        '''
        Type: 查询条件类型，供生成查询条件字符串时使用
        '''
        QueryType={"LIKE":"LIKE",  #相似
                   "EQUAL":"EQUAL", #等于
                   "NOT":"NOT",   #不等于
                   "RANGE":"RANGE"  #位于左闭右开的区间，传入的参数为列表
                  }
        '''
        Type: 排序条件类型，供生成查询条件字符串时使用
        '''
        SortType={"ASC":"ASC",  #升序
                  "DESC":"DESC" #降序
                  }
        
        '''
        Function：生成批量查询命令中需要的条件字符串
        Params:
            queryList为查询条件列表，不存在则为None，当前仅支持一个查询列表，每个查询条件为一个三元字典，格式为：{"index":ArgIndex, "type":QueryType, "value"：ArgValue}
            sortinfo为二元字典，不存在则为None，格式为{"index":ArgIndex, "type":SortType}
            rangeinfo为二元字典，不存在则为None，格式为{"start":StartLineIndex, "end":EndLineIndex(not include)}
        Reuslt: queryCondition字段所需的字符串
        Attention: 
            1、受创建方法限制，传入的参数值中不能带有单引号；
            2、由于仅有少部分命令支持查询条件，故更多的查询结果筛选需使用Record子类中的filter方法
        '''
        @staticmethod
        def getQueryConditionString(queryDictList, sortDict, rangeDict):
            retCondition = {}
            #构造查询字符串
            if None != queryDictList:
                queryDict = {}
                for cond in queryDictList:
                    queryType = cond["type"]
                    if Tlv.Param.QueryType["LIKE"] == queryType:
                        queryDict[str(cond["index"])] = "LIKE" + str(cond["value"])
                    elif Tlv.Param.QueryType["EQUAL"] == queryType:
                        queryDict[str(cond["index"])] = str(cond["value"])
                    elif Tlv.Param.QueryType["NOT"] == queryType:
                        queryDict[str(cond["index"])] = "NOT" + str(cond["value"])
                    elif Tlv.Param.QueryType["RANGE"] == queryType:
                        range = cond["value"]
                        queryDict[str(cond["index"])] = "[" + str(range[0]) + "," + str(range[1]) + ")"
                    else:
                        return "Invalid query condition: " + str(cond)
                retCondition["query"] = [queryDict]
            #构造排序字符串
            if None != sortDict:
                strSort = str(sortDict["index"]) + str(sortDict["type"])
                retCondition["sortby"] = strSort
            #构造区间字符串
            if None != rangeDict:
                strRange = str(rangeDict["start"]) + "-" + str(rangeDict["end"])
                retCondition["range"] = strRange
            #采用Python的str将条件字典转换为字符串，并将其中的单引号替换为双引号
            return str(retCondition).replace('\'', '\"')
        
        
    '''
    TLV连接管理类
    '''
    class Conn():
        #持久化数据保存KEY
        PERSIST_CONN = "TLV_CONNECTION"
        
        '''
        Function: 获取指定设备的TLV连接
        '''
        @staticmethod
        def getConnByIP(context, ip, user, pawd, port):
            
            #从上下文中获取指定IP的TLV连接器
            tlvConnector = persist.getObject(context, Tlv.Conn.PERSIST_CONN, ip)
            tlvConn = None
            
            if None != tlvConnector:
                #直接从已有TLV连接器中获取连接
                log.info(context, "tlv connector is already existed. ip=" + ip)
                try:

                    tlvConn = tlvConnector.getConnection()
                    
                except ToolException, e:
                    #记录错误并直接抛出异常
                    log.error(context, "fail to get tlv connection. ip=" + ip 
                              + ", the dev is abnormal or the network is abnormal.")
                    raise exception.getToolExceptionByErrId(e)
                
            else:
                #创建新的TLV连接器和连接
                #获取TLV连接参数
                connFactory  =  contextUtil.getConnectorFactoryObj(context)
                ssl = True  #连接是否使用安全套接字连接

                #循环连接(框架异常时直接抛出异常)
                counter= 0
                MAX_RETRAY_TIME = 3
                while True:
                    counter += 1
                    
                    try:
                        #创建TLV连接
                        '''
                        Question：T系列C00和C10中创建TLV连接时的差异，将导致连接创建时出现“用户名或密码错误”异常
                        '''
                        try:
                            cli = contextUtil.getCLI(context)
                            cliUtil.openTlvChannel(cli)
                        except:
                            log.info(context, "open tlv channel exception")

                        tlvConnector = None
                        #中低端场景
                        if "," not in ip:
                            tlvConnector = connFactory.createTlvConnector(ip, port, user, pawd, ssl)
                        #高端场景
                        else:
                            tempList = ip.split(",")
                            innerIpList = JavaList()
                            for innerIp in tempList:
                                innerIpList.add(String(innerIp))
                            tlvConnector = connFactory.createTlvConnector(innerIpList, port, user, pawd, ssl)
                        del pawd
                        tlvConn = tlvConnector.getConnection()
                        #保存TLV连接（后续使用时不再创建）
                        persist.setObject(context, Tlv.Conn.PERSIST_CONN, ip, tlvConnector)
                        log.info(context, "succeed to create and save tlv connector. ip=" + ip)
                        
                        #连接正常，则退出循环连接
                        break 
                        
                    except ToolException, e:
                        #记录错误并直接抛出异常
                        log.error(context, "Framework Exception: fail to create tlv connector. ip=" + ip 
                                  + ", errorid=" + e.getErrorId() + ", errmsg=" + e.getErrMsg() +", do not retry.")
                        raise exception.getToolExceptionByErrId(e)
                    
                    except Exception, e:
                        #记录错误并重试
                        counter = counter + 1
                        log.error(context, "the " + str(counter) + "th failed to create tlv connector. ip=" + ip 
                                  + ", errinfo=%s" % traceback.format_exc() + ", try again...")
                    
                    #若三次重试仍未建立TLV连接，则报错
                    if counter > MAX_RETRAY_TIME:
                        tlvConn = None
                        log.error(context, "fail to create tlv connector. ip=" + ip + ", met the max try time 3.")
                        raise exception.newToolException(u"创建到设备" + ip + u"的TLV连接失败。", 
                                        const.HELP_DESC_ZH,
                                        "Failed to create the TLV connection to device " + ip + ".",
                                        const.HELP_DESC_EN)
            #返回连接创建结果
            return tlvConn
        

        '''
        Function: 获取与SVP的连接
        '''
        @staticmethod
        def getTlvConnectionSVP(context):
            
            IP_DEFAULT = "172.17.126.11"
            PORT_DEFAULT = "19002"
            DEFAULT_FLAG = "186042"
            DEVICE_TYPE = "svp"
            SN = contextUtil.getDevSN(context)+"svp"
            
            #从上下文中获取指定IP的TLV连接器
            tlvConnector = persist.getObject(context, Tlv.Conn.PERSIST_CONN, IP_DEFAULT)
            tlvConn = None
            
            if None != tlvConnector:
                #直接从已有TLV连接器中获取连接
                log.info(context, "tlv connector is already existed. ip=" + IP_DEFAULT)
                try:
                    tlvConn = tlvConnector.getConnectionSVP()
                    
                except ToolException, e:
                    #记录错误并直接抛出异常
                    log.error(context, "fail to get tlv connection. ip=" + IP_DEFAULT 
                              + ", the dev is abnormal or the network is abnormal.")
                    raise exception.getToolExceptionByErrId(e)
                
            else:
                #创建新的TLV连接器和连接
                #获取TLV连接参数
                connFactory  =  contextUtil.getConnectorFactoryObj(context)
                
                #循环连接(框架异常时直接抛出异常)
                counter= 0
                MAX_RETRAY_TIME = 3
                while True:
                    counter += 1
                    
                    try:
                        #创建TLV连接
                        '''
                        Question：T系列C00和C10中创建TLV连接时的差异，将导致连接创建时出现“用户名或密码错误”异常
                        '''
                        tlvConnector = None
                        
                        tlvConnector = connFactory.createTlvConnectorSVP(IP_DEFAULT, PORT_DEFAULT, DEFAULT_FLAG, DEVICE_TYPE, SN)

                        tlvConn = tlvConnector.getConnectionSVP()
                        #保存TLV连接（后续使用时不再创建）
                        persist.setObject(context, Tlv.Conn.PERSIST_CONN, IP_DEFAULT, tlvConnector)
                        log.info(context, "succeed to create and save tlv connector. ip=" + IP_DEFAULT)
                        
                        #连接正常，则退出循环连接
                        break 
                        
                    except ToolException, e:
                        #记录错误并直接抛出异常
                        log.error(context, "Framework Exception: fail to create tlv connector. ip=" + IP_DEFAULT 
                                  + ", errorid=" + e.getErrorId() + ", errmsg=" + e.getErrMsg() +", do not retry.")
                        raise exception.getToolExceptionByErrId(e)
                    
                    except Exception, e:
                        #记录错误并重试
                        counter = counter + 1
                        log.error(context, "the " + str(counter) + "th failed to create tlv connector. ip=" + IP_DEFAULT 
                                  + ", errinfo=" + str(e) + ", try again...")
                    
                    #若三次重试仍未建立TLV连接，则报错
                    if counter > MAX_RETRAY_TIME:
                        tlvConn = None
                        log.error(context, "fail to create tlv connector. ip=" + IP_DEFAULT + ", met the max try time 3.")
                        raise exception.newToolException(u"创建到设备" + IP_DEFAULT + u"的TLV连接失败。", 
                                        const.HELP_DESC_ZH,
                                        "Failed to create the TLV connection to device " + IP_DEFAULT + ".",
                                        const.HELP_DESC_EN)
            #返回连接创建结果
            return tlvConn
                
        '''
                        获取当前设备TLV连接
        '''
        @staticmethod
        def getConn(context):
            ip = contextUtil.getIp(context)
            
            toolIp = contextUtil.getItem(context, "TOOL_CONNECT_IP")
            if toolIp and toolIp != "":
                ip = toolIp

            innerIps = contextUtil.getInnerIp(context)
            if innerIps is not None:
                ip = innerIps
            
            user = contextUtil.getNewDevObj(context).get("user")
            pawd = contextUtil.getNewDevObj(context).get("pawd")
            tlvPort = Tlv.Const.TLVPORT_DEFAULT
            log.info(context, "ready to get tlv connector. login info: ip=" + str(ip)
                      + ", user=" + str(user) + ", tlvPort=" + str(tlvPort))
            
            conn = Tlv.Conn.getConnByIP(context, ip, user, pawd, tlvPort)
            del pawd
            return conn
        
        '''
                        与制定IP建立TLV连接
        '''
        @staticmethod
        def getConnThroughSpecificIp(context,ip):
            user = contextUtil.getNewDevObj(context).get("user")
            pawd = contextUtil.getNewDevObj(context).get("pawd")
            tlvPort = Tlv.Const.TLVPORT_DEFAULT
            log.info(context, "ready to get a new tlv connector. login info: ip=" + str(ip)
                      + ", user=" + str(user) + ", tlvPort=" + str(tlvPort))
            
            currentIp = contextUtil.getNewDevObj(context).get("ip")
            isDelete = persist.delObject(context, Tlv.Conn.PERSIST_CONN, currentIp)
            log.info(context, "delete current link ," + str(isDelete))
            
            if isDelete:
                contextUtil.getNewDevObj(context)["ip"] = ip
                conn = Tlv.Conn.getConnByIP(context, ip, user, pawd, tlvPort)
                del pawd
            return conn
    
    '''
    TLV常量类
    '''
    class Record():
        
        '''
        Function: 获取Record中的元素个数
        Params: record=TLV执行后返回的记录对象
        Return: Record的元素个数
        '''
        @staticmethod
        def getItemCount(record, itemId):
            return record.getFieldCount()
        
        '''
        Function: 判断Record中指定ID的元素是否存在
        Params: record=TLV执行后返回的记录对象; itemId=TLV参数项位置
        Return: 是否存在。True=存在； False=不存在
        '''
        @staticmethod
        def isItemExisted(record, itemId):
            #尝试获取指定ID的元素，若能获取到，则说明存在；不存在时将抛出异常
            isExisted = False
            try:
                obj = Tlv.Record.getValue(record, itemId)
                if None != obj:
                    isExisted = True
                else:
                    isExisted = False
            except Exception, e:
                isExisted = False
                
            return isExisted
        
        '''
        isItemExisted函数的测试函数，可配合用于确认某个地方是否存在TLV缺陷
        '''
        @staticmethod
        def isItemExisted_TEST(context, record, itemId):
            #尝试获取指定ID的元素，若能获取到，则说明存在；不存在时将抛出异常
            isExisted = False
            try:
                obj = Tlv.Record.getValue(record, itemId)
                log.info(context, "record=" + str(record))
                log.info(context, "itemId=" + str(itemId) + ", obj=" + str(obj))
                if None != obj:
                    isExisted = True
                else:
                    isExisted = False
            except Exception, e:
                isExisted = False
                
            log.info(context, "isExisted=" + str(isExisted))
            return isExisted
        
        
        '''
        Function: 从Record中获取参数
        Params: record=TLV执行后返回的记录对象；itemId=TLV参数项位置
        Return: TLV参数项值
        '''
        @staticmethod
        def getValue(record, itemId):
            return record.getParamValue(itemId)
        
        '''
        Function: 从Record中获取字符串类参数
        Params: record=TLV执行后返回的记录对象；itemId=TLV参数项位置
        Return: TLV参数项值
        '''
        @staticmethod
        def getStrValue(record, itemId):
            try:
                return str(record.getParamStrValue(itemId))
            except:
                return str(record.getParamStrValue(itemId).encode("utf-8"))
        
        '''
        Function: 从Record中获取Int32型参数
        Params: record=TLV执行后返回的记录对象；itemId=TLV参数项位置
        Return: TLV参数项值
        '''
        @staticmethod
        def getIntValue(record, itemId):
            return record.getParamIntValue(itemId).intValue()
        
        @staticmethod
        def getBoolValue(record, itemId):
            return record.getParamStrValue(itemId)
        
        '''
        Function: 从Record中获取Int64型参数
        Params: record=TLV执行后返回的记录对象；itemId=TLV参数项位置
        Return: TLV参数项值
        '''
        @staticmethod
        def getLongValue(record, itemId):
            return record.getParamIntValue(itemId).longValue()
        
        
        '''
        Type: 条件类型，供生成TLV命令记录条件用（命名类似于Shell比较运算符）
        '''
        ConditionType={"LIKE":"LIKE",  #相似(采用正则表达式匹配)：支持字符串和数字,数字将自动被转换为字符串进行判断
                   "NLIKE":"NLIKE",  #不相似(采用正则表达式匹配)：支持字符串和数字,数字将自动被转换为字符串进行判断
                   "EQ":"EQ",  #等于: EQual：支持字符串和数字
                   "NE":"NE",  #不等于: Not Equal：支持字符串和数字
                   "GT":"GT",  #大于：Greater Than：仅支持数字
                   "GE":"GE",  #大于等于: Greater or Equal：仅支持数字
                   "LT":"LT",  #小于：Little Than：仅支持数字
                   "LE":"LE",  #大于：Little or Equal：仅支持数字
                   "EQOR":"EQOR",  #等于[或等于](满足多个EQ条件中任一即可): EQual OR：支持字符串和数字
                   "NEAND":"NEAND",  #不等于[并且不等于](同时不满足多个NE条件): Not Equal AND：支持字符串和数字
                   "LIKEOR":"LIKEOR",  #与*相似[或与##相似](满足多个LIKE条件中任一即可): LIKE OR：支持字符串和数字,数字将自动被转换为字符串进行判断
                  }
        
        '''
        Function：生成多条件值列表，供EQOR、NEAND和LIKEOR使用
        Params:
            allValue：筛选的所有条件值。如4,1,50 或"x","dfsd","234"
        Return: 条件值构成的字符串列表
        '''
        @staticmethod
        def getMultiConditionValueList(*allValue):
            valueList = []
            for value in allValue:
                #此处将所有条件值均转为字符串，方便后续的比较
                valueList.append(str(value))
            return valueList
        
        
        '''
        Function：生成单个条件字典
        Params:
            argIndex：记录值项的索引。如parentID=4
            filterType：筛选类型。参见ConditionType字典的定义
            argValue：筛选的条件值
            paramIdx：兼容处理，匹配告警参数索引
        Return: 条件字典，格式为{"index":ArgIndex, "type":ConditionType, "value"：ArgValue}
        Example: 要求parentID=4的项为28，则入口参数为（4， "EQ", 28）
        '''
        @staticmethod
        def getCondition(argIndex, filterType, argValue, paramIdx=-1):
            #参数校验，不正确时直接抛出异常
            if type(argIndex) != int:
                raise Exception("argIndex is not a integer: " + str(type(argIndex)))
            filterType = str(filterType)
            if filterType not in Tlv.Record.ConditionType.values():
                raise Exception("unsupported record filter type: " + str(filterType))
            
            #返回结果
            return {"index":argIndex, "type":filterType, "value":argValue, "paramIdx":paramIdx}
        
        '''
        Function：生成多条件列表
        Params: allCondition：所有的条件，0或多个，由getCondition()获得
        Return: 条件列表
        '''
        @staticmethod
        def getConditionList(*allCondition):
            conditionList = []
            for condition in allCondition:
                conditionList.append(condition)
            return conditionList
        
        '''
        Function：筛选出满足指定条件的记录
        Params:
            recordList为待筛选的记录列表
            conditionList为筛选条件列表，不存在则为None，当前仅支持一个条件列表，
                                            每个条件为一个三元字典，格式为：{"index":ArgIndex, "type":ConditionType, "value"：ArgValue}
        Return: 筛选结果 （Java ArrayList） or 抛出异常（参数或运行错误时）
        '''
        @staticmethod
        def filter(recordList, conditionList): #context, 
            #入口参数校验
            if None == recordList:
                return JavaList() #返回空List
            if None == conditionList:
                return recordList
            #依次按recordList中的条件对传入的记录集进行筛选
            for cond in conditionList:
                #初始化新的记录列表用于存放本轮筛选结果
                retRecList = JavaList()
                #获取条件信息
                index = int(cond["index"])
                type = str(cond["type"])
                value = cond["value"]
                if isinstance(value, list) or isinstance(value, tuple):
                    #如果匹配值为字典或元组，则将其元素转换为字符串，方便下面匹配
                    tmpList = []
                    for item in value:
                        tmpList.append(str(item))
                    value = tmpList
                #遍历所有的记录进行筛选
                recNum = recordList.size()
                for i in range(0, recNum):
                    #获取当前记录及相应的条件值（默认为字符串类型）
                    rec = recordList.get(i)
                    #按不同的条件类型进行筛选
                    if Tlv.Record.ConditionType["LIKE"] == type:
                        recValue = str(Tlv.Record.getStrValue(rec, index))
                        value = str(value)
                        if None != re.search(value, recValue):#, re.IGNORECASE): #此处需区分大小写
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["NLIKE"] == type:
                        recValue = str(Tlv.Record.getStrValue(rec, index))
                        value = str(value)
                        if None == re.search(value, recValue):#, re.IGNORECASE): #此处需区分大小写
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["EQ"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        paramIdx = cond.get("paramIdx",-1)
                        #告警、事件可以指定参数
                        if paramIdx != -1:
                            #告警、事件指定的参数
                            vals = str(recValue).split(",")
                            if paramIdx < len(vals):
                                recValue = vals[paramIdx]
                            
                        if str(recValue).strip() == str(value).strip():
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["NE"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) != str(value):
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["GT"] == type:
                        #范围类型为数值（直接按Long取，避免溢出，范围为左闭右开）
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue > value:
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["GE"] == type:
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue >= value:
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["LT"] == type:
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue < value:
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["LE"] == type:
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue <= value:
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["EQOR"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) in value: #此时value为字符串列表
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["NEAND"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) not in value: #此时value为字符串列表
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["LIKEOR"] == type:
                        recValue = str(Tlv.Record.getValue(rec, index))
                        for item in value:#此时value为字符串列表
                            if None != re.search(item, recValue):#, re.IGNORECASE): #此处需区分大小写
                                retRecList.add(rec)
                                break
                    else:
                        raise Exception("Invalid query condition type=" + type + " in condition=" + + str(cond))
                #置待筛选集合为当前筛选结果，进入下轮筛选
                recordList = retRecList
            #返回筛选结果
            return retRecList
        
        
        
        @staticmethod
        def filter_test(context, recordList, conditionList): #context, 
            #入口参数校验
            if None == recordList:
                return JavaList() #返回空List
            if None == conditionList:
                return recordList
            #依次按recordList中的条件对传入的记录集进行筛选
            log.info(context, "conditionList=" + str(conditionList))
            for cond in conditionList:
                #初始化新的记录列表用于存放本轮筛选结果
                retRecList = JavaList()
                #获取条件信息
                log.info(context, "condition=" + str(cond))
                index = int(cond["index"])
                type = str(cond["type"])
                value = cond["value"]
                if isinstance(value, list) or isinstance(value, tuple):
                    #如果匹配值为字典或元组，则将其元素转换为字符串，方便下面匹配
                    tmpList = []
                    for item in value:
                        tmpList.append(str(item))
                    value = tmpList
                #遍历所有的记录进行筛选
                recNum = recordList.size()
                for i in range(0, recNum):
                    #获取当前记录及相应的条件值（默认为字符串类型）
                    rec = recordList.get(i)
                    #按不同的条件类型进行筛选
                    if Tlv.Record.ConditionType["LIKE"] == type:
                        recValue = str(Tlv.Record.getStrValue(rec, index))
                        value = str(value)
                        if None != re.search(value, recValue):#, re.IGNORECASE): #此处需区分大小写
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["NLIKE"] == type:
                        recValue = str(Tlv.Record.getStrValue(rec, index))
                        value = str(value)
                        if None == re.search(value, recValue):#, re.IGNORECASE): #此处需区分大小写
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["EQ"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) == str(value):
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["NE"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) != str(value):
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["GT"] == type:
                        #范围类型为数值（直接按Long取，避免溢出，范围为左闭右开）
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue > value:
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["GE"] == type:
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue >= value:
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["LT"] == type:
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue < value:
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["LE"] == type:
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue <= value:
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["EQOR"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) in value: #此时value为字符串列表
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["NEAND"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) not in value: #此时value为字符串列表
                            retRecList.add(rec)
                    elif Tlv.Record.ConditionType["LIKEOR"] == type:
                        recValue = str(Tlv.Record.getValue(rec, index))
                        for item in value:#此时value为字符串列表
                            if None != re.search(item, recValue):#, re.IGNORECASE): #此处需区分大小写
                                retRecList.add(rec)
                                break
                    else:
                        raise Exception("Invalid query condition type=" + type + " in condition=" + + str(cond))
                #置待筛选集合为当前筛选结果，进入下轮筛选
                recordList = retRecList
            #返回筛选结果
            return retRecList
        
        
        
        
        '''
        Function：依次按指定的条件对所有记录进行排序，满足条件的放在前部，不满足条件的放在尾部
        Params:
            recordList为待排序的记录列表
            conditionList为排序条件列表，不存在则为None，当前仅支持一个条件列表，
                                            每个条件为一个三元字典，格式为：{"index":ArgIndex, "type":ConditionType, "value"：ArgValue}
        Return: 排序结果 （Java ArrayList）
        Method: 程序依次按条件的排列顺序对输入记录进行排序，一条记录仅参与其满足的第一个条件的排序，满足某个条件后，将不再参与后面条件的排序。
                                        满足第一个条件的记录顺序排在结果集首部，满足第二个条件的记录次之，并依次类推；对于不满足任何条件的记录，顺序排在结果集的尾部。
        '''
        @staticmethod
        def topSort(recordList, conditionList): #context, 
            #入口参数校验
            if None == recordList:
                return None
            if None == conditionList:
                return recordList
            #依次按recordList中的条件对传入的记录集进行排序
            #初始化的时的记录列表
            retRecList = JavaList()
            for cond in conditionList:
                #初始化临时记录列表，保存不满足本次排序条件的记录
                tmpRecList = JavaList()
                #获取条件信息
                index = int(cond["index"])
                type = str(cond["type"])
                value = cond["value"]
                if isinstance(value, list) or isinstance(value, tuple):
                    #如果匹配值为字典或元组，则将其元素转换为字符串，方便下面匹配
                    tmpList = []
                    for item in value:
                        tmpList.append(str(item))
                    value = tmpList
                #遍历所有的记录进行筛选
                recNum = recordList.size()
                for i in range(0, recNum):
                    #获取当前记录及相应的条件值（默认为字符串类型）
                    rec = recordList.get(i)
                    isSorted = False
                    #按不同的条件类型进行筛选
                    if Tlv.Record.ConditionType["LIKE"] == type:
                        recValue = str(Tlv.Record.getStrValue(rec, index))
                        value = str(value)
                        if None != re.search(value, recValue):#, re.IGNORECASE): #此处需区分大小写
                            isSorted = True
                    elif Tlv.Record.ConditionType["NLIKE"] == type:
                        recValue = str(Tlv.Record.getStrValue(rec, index))
                        value = str(value)
                        if None == re.search(value, recValue):#, re.IGNORECASE): #此处需区分大小写
                            isSorted = True
                    elif Tlv.Record.ConditionType["EQ"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) == str(value):
                            isSorted = True
                    elif Tlv.Record.ConditionType["NE"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) != str(value):
                            isSorted = True
                    elif Tlv.Record.ConditionType["GT"] == type:
                        #范围类型为数值（直接按Long取，避免溢出，范围为左闭右开）
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue > value:
                            isSorted = True
                    elif Tlv.Record.ConditionType["GE"] == type:
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue >= value:
                            isSorted = True
                    elif Tlv.Record.ConditionType["LT"] == type:
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue < value:
                            isSorted = True
                    elif Tlv.Record.ConditionType["LE"] == type:
                        recValue = Tlv.Record.getLongValue(rec, index)
                        if recValue <= value:
                            isSorted = True
                    elif Tlv.Record.ConditionType["EQOR"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) in value: #此时value为字符串列表
                            isSorted = True
                    elif Tlv.Record.ConditionType["NEAND"] == type:
                        recValue = Tlv.Record.getValue(rec, index)
                        if str(recValue) not in value: #此时value为字符串列表
                            isSorted = True
                    elif Tlv.Record.ConditionType["LIKEOR"] == type:
                        recValue = str(Tlv.Record.getValue(rec, index))
                        for item in value:#此时value为字符串列表
                            if None != re.search(item, recValue):#, re.IGNORECASE): #此处需区分大小写
                                isSorted = True
                                break
                    else:
                        raise Exception("Invalid query condition type=" + type + " in condition=" + + str(cond))
                    #处理排序结果
                    if True == isSorted:
                        #当前记录满足排序条件时，则将其存入返回记录集
                        retRecList.add(rec)
                    else:
                        #若当前记录不满足排序条件，则存入临时记录列表中，留待匹配后续的条件
                        tmpRecList.add(rec)
                #置待筛选集合为当前筛选结果，进入下轮筛选
                if 0 == tmpRecList.size():
                    break
                else:
                    recordList = tmpRecList
            #将不满足排序条件的记录放入retRecList尾部
            recNum = tmpRecList.size()
            for i in range(0, recNum):
                rec = tmpRecList.get(i)
                retRecList.add(rec)
            #返回筛选结果
            return retRecList
        
        @staticmethod
        def logRecList(context, recordList, strDesc=None):
            #构造记录字符串
            strRec = ""
            if None != recordList:
                recNum = recordList.size()
                for index in range(0, recNum):
                    strRec = strRec + str(recordList.get(index)) + "\n"
            else:
                strRec = str(None)
            #添加描述
            strHead = "\n"
            if type(strDesc) == str:
                strHead = strHead + strDesc + "\n"
            #打印记录(尽量将所有的函数调用关系均打印出来)
            log.info(context, strHead
                     + "====================logRecList BEGIN====================\n"
                     + strRec
                     + "====================logRecList END====================\n"
                     + log.getCallerInfo(10))
            return
        
    '''
    TLV常量类
    '''
    class Const():
    
        '''
                    默认TLV连接端口号，建立TLV连接时，需使用这个端口
        '''
        TLVPORT_DEFAULT = 8080
        
        '''
        TLV命令执行超时时间(秒)
        '''
        TIMEOUT_DEFAULT = 90
        
        '''
        2800V3单控下电控制器TLV命令执行超时时间(秒)
        '''
        TIMEOUT_FOR_2800V3SINGLE_OFFLINE_CONTROLLER = 3600
        
        '''
        TLV执行后的结果集的结束标识
        '''
        RECORD_ENDFLAG = 4095
        
        '''
        TLV执行批量查询时的最大条数（自选）
        '''
        RECORD_MAXNUM = 100
        
        '''
        TLV预留异常ID范围：-10000 ~ -11000
        '''
        #TLV执行错误ID，执行结果为空（非None，即有一个不存在任何元素的行）。
        ERRID_EMPTY_RESULT = "-10001"        
        #TLV执行错误ID，执行结果为None。
        ERRID_NONE_RESULT = "-10002"
        
        
