# -*- coding: UTF-8 -*-

CLI_EXECUTE_CMD_SUCCESS = "Command executed successfully"
DEBUG_MODEL_FLAG = ":/diagnose>"
DEVELOPER_MODEL_FLAG = "developer:/>"
CLI_RET_END_FLAG = ":/>"
DIAGNOSE_RET_END_FLAG = "diagnose>"
MINISYSTEM_MODEL_FLAG = "minisystem>"
STORAGE_MODEL_FLAG = "Storage:~ #"

DIAGNOSE_SYS_SHOW_CLS_CMD = 'sys showcls'

RESULT_NOCHECK = "NOCHECK"
RESULT_NOSUPPORT = "NOSUPPORT"
RESULT_WARNING = "WARNING"
RESULT_DICT = {
   True:"0",
   False:"1",
   RESULT_NOCHECK:"2",
   RESULT_NOSUPPORT:"3",
   RESULT_WARNING:"4",
}

def isNoneLicense(cliRet):
    '''
    @summary: 判断回显结果里面是否包含需要license
    @param cliRet: cli回显
    @return: 
        True: cli回显包含需要license
        False: cli回显不包含需要license
    '''
    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        lowerLine = line.lower()
        if "license" in lowerLine and ("error" in lowerLine or "suggestion" in lowerLine):
            return True

    return False

def hasCliExecPrivilege(cliRet):
    '''
    @summary: 判断是否具有执行cli命令的权限
    @param cliRet: cli回显
    @return: 
        True: 具有执行cli命令的权限
        False: 不具有执行cli命令的权限
    '''
    for line in cliRet.splitlines():
        if line.strip() == "^":
            return False
        if "use the tab key to check that the command format is correct and then try again" in line.lower():
            return False
        if "does not have the permission" in line:
            return False
    return True

def queryResultWithNoRecord(cliRet):
    '''
    @summary: 判断回显是否为Command executed successfully
    @param cliRet: cli回显
    @return: 
        True: cli回显中包含Command executed successfully
        False: cli回显中不包含Command executed successfully
    '''
    if CLI_EXECUTE_CMD_SUCCESS in cliRet:
        return True
    return False

def isInternalError(cliRet):
    '''
    @summary: 判断回显结果是否包含内部错误信息
    @param cliRet: cli回显
    @return: 
        True: cli回显包含内部错误信息
        False: cli回显不包含内部错误信息
    '''
    lowerCliRet = cliRet.lower()
    if "internal error" in lowerCliRet:
        return True
    else:
        return False

def checkLineInBlackList(cliLine):
    '''
    @summary: 判断cli语句行是否在黑名单中
    @param cliLine: cli语句行
    @return:
        True: cli语句行在黑名单中
        False: cli语句行不在黑名单中
    '''
    for dictItems in BLACKLIST_DICT:
        if dictItems.get("key_word") in cliLine:
            return True
    return False

def excuteCmdInCliMode(cli, cmd):
    '''
    @summary: 获取cli模式下执行命令后的回显
    @param cli: cli对象
    @param cmd: 待执行命令
    @param isHasLog: 是否需要以有log的方式执行cli命令下发
    @return: (falg, cliRet, errMsg)
        flag:
            True: 执行命令正常
            False: 执行命令不正常
        cliRet: Cli回显信息
    '''
    cliRet = cli.execCmd(cmd)
    if len(cliRet) == 0:
        return False, cliRet

    if isSupportFeature(cliRet):
        return RESULT_NOSUPPORT, cliRet

    if isNoneLicense(cliRet):
        return RESULT_NOSUPPORT, cliRet

    if not hasCliExecPrivilege(cliRet):
        return RESULT_NOSUPPORT, cliRet

    if queryResultWithNoRecord(cliRet):
        return True, cliRet

    if isInternalError(cliRet):
        return False, cliRet
    return True, cliRet

def isSupportFeature(cliRet):
    '''
    @summary: 判断是否支持某特性
    '''
    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        lowerLine = line.lower()
        if "error:" in lowerLine and "not support" in lowerLine:
            return True
        #【注意】升级类工具专用：全是使用admin执行，所以不存在权限不足情况
        if lowerLine.strip() == "^":
            return True

    return False

def isSupportFeatureBySSH(cli, cmd):
    '''
    @summary: 判断是否支持此特性
    '''
    cliRet = cli.execCmd(cmd)
    supportFlag = not isSupportFeature(cliRet)
    return (supportFlag, cliRet)

BLACKLIST_DICT = [
{
    "key_word":"-bash:",
    "msg_zh":u"\n系统没有运行在admin模式",
    "msg_en":"\nSystem is not in admin mode"
 },

{
    "key_word":"Storage:",
    "msg_zh":u"\n系统没有运行在admin模式",
    "msg_en":"\nSystem is not in admin mode"
 },

{
    "key_word":"minisystem",
    "msg_zh":u"\n系统没有运行在admin模式",
    "msg_en":"\nSystem is not in admin mode"
 },

{
    "key_word":"upgrade:/>",
    "msg_zh":u"\n系统处于升级模式",
    "msg_en":"\nSystem is in upgrade Mode"
 },

{
    "key_word":"System is in safe mode",
    "msg_zh":u"\n系统处于安全模式",
    "msg_en":"\nSystem is in safe mode"
},

{
    "key_word":"System is not ready",
    "msg_zh":u"\n系统正在启动中",
    "msg_en":"\nSystem is not ready"
},

{
    "key_word":"The system is powering off",
    "msg_zh":u"\n系统处于下电模式",
    "msg_en":"\nThe system is powering off"
 },

{
    "key_word":"The system failed to be started",
    "msg_zh":u"\n系统启动失败",
    "msg_en":"\nThe system failed to be started"
 },

{
    "key_word":"Use the Tab key to check that the command format is correct and then try again",
    "msg_zh":u"\n命令不支持",
    "msg_en":"\nCommand is not supported"
 },

{
    "key_word":"^",
    "msg_zh":u"\n命令不支持",
    "msg_en":"\nCommand is not supported"
 },

{
    "key_word":"system is busy",
    "msg_zh":u"\n系统忙",
    "msg_en":"\nSystem is busy"
 },

{
    "key_word":"Processing...",
    "msg_zh":u"\n系统处理中",
    "msg_en":"\nSystem is processing"
 },

{
    "key_word":"Socket connect failed",
    "msg_zh":u"\nSocket连接失败",
    "msg_en":"\nSocket connect failed"
 },

{
    "key_word":"Failed to process the message",
    "msg_zh":u"\n处理失败",
    "msg_en":"\nFailed to process the message"
 },

{
    "key_word":"Operation timeout",
    "msg_zh":u"\n执行超时",
    "msg_en":"\nOperation timeout"
 },

{
    "key_word":"Receive message time out",
    "msg_zh":u"\n信息查询超时",
    "msg_en":"\nReceive message time out"
 },

{
    "key_word":"Error:",
    "msg_zh":u"\n系统异常",
    "msg_en":"\nSystem is abnormal"
 },

{
    "key_word":"Error :",
    "msg_zh":u"\n系统异常",
    "msg_en":"\nSystem is abnormal"
 },

 {
    "key_word":"Error: The user does not have the permission",
    "msg_zh":u"\n用户没有权限",
    "msg_en":"\nThe user does not have the permission"
 },
]
