# -*- coding: UTF-8 -*-

import os
import sys

SCRIPT_DEF_CONTEXT = "SCRIPT_DEF_CONTEXT"
RESOURCE_DEF_CONTEXT = "RESOURCE_DEF_CONTEXT"

#设备分类
class DevClass:
    V1 = "V1"
    V2 = "V2"
    V3V5 = "V3V5"
    COMMON = "COMMON"

def getLang(context):
    '''
    @summary: 获取语言
    @param context: 上下文对象
    '''
    return context.get("lang")

def getLogger(context):
    '''
    @summary: 获取日志打印对象
    @param context: 上下文对象
    '''
    return context.get("logger")

def getSSH(context):
    '''
    @summary: 获取工具与阵列的SSH连接对象
    '''
    return context.get('ssh')

def getSFTP(context):
    '''
    @summary: 获取工具与阵列的SFTP连接对象
    '''
    return context.get('sftp')

def getDevObj(context):
    '''
    @summary: 获取上下文对象中dev对象
    @param context: 上下文对象
    '''
    return context.get("dev")

def getDevType(context):
    '''
    @summary: 获取设备类型
    '''
    return getDevObj(context).getDeviceModel()

def getDevSN(context):
    '''
    @summary: 获取设备序列号Serial Number
    '''
    return getDevObj(context).getDeviceSerialNumber()

def getCurVersion(context):
    '''
    @summary: 获取系统当前版本
    @param context: 上下文对象
    '''
    return getDevObj(context).getProductVersion()

def getTargetVersion(context):
    '''
    @summary: 获取目标版本号
    @param context: 上下文对象
    '''
    return getDevObj(context).getDestVersion()

def getScriptDefDict(context):
    '''
    @summary: 获取上下文自定义字典
    @param context: 上下文对象
    '''
    if isinstance(context, dict):
        if not context.has_key(SCRIPT_DEF_CONTEXT):
            context.setdefault(SCRIPT_DEF_CONTEXT, {})
    else:
        if not context.containsKey(SCRIPT_DEF_CONTEXT):
            context.put(SCRIPT_DEF_CONTEXT, {})
    return context.get(SCRIPT_DEF_CONTEXT)

def getLoginUserName(context):
    '''
    @summary: 获取登录用户名
    '''
    return getDevObj(context).getLoginUser().getUserName()

def getDevLoginUserPwd(context):
    '''
    @summary: 获取上下文对象中dev对象中的的登录密码
    @param context: 上下文对象
    '''
    dev = getDevObj(context)
    return dev.getLoginUser().getPassword()

def getDeveloperPwd(context):
    '''
    @summary: 获取developer密码
    @param context: 上下文对象
    '''
    return getDevObj(context).getDeveloperPwd()

def getDevPort(context):
    '''
    @summary: 获取上下文对象中dev对象中的的登录端口
    @param context: 上下文对象
    '''
    dev = getDevObj(context)
    return dev.getPort()

def getTmpDir(context):
    '''
    @summary: 获取子工具运行根目录下的临时目录
    '''
    return context.get('tmpDir')

def getUpgradeModel(context):
    '''
    @summary: 获取升级模式（在线或者离线），其值为"ONLINE"或"OFFLINE"
    @param context: 上下文对象
    '''
    return str(getDevObj(context).getUpgradeMode())

def getCurCtrlIp(context):
    '''
    @summary: 获取设备当前控制器IP
    @param context: 上下文对象
    '''
    return getDevObj(context).getIp()

def getImportRootDir(context):
    '''
    @summary: 获取脚本的根目录
    @param context: 上下文对象
    '''
    return os.path.dirname(context.get("importRootDir"))

def isPreUpgradeCheckScene(context):
    '''
    @summary: 是否为升级前工勘场景化
    @param context: 上下文对象
    '''
    return context.get("isPreUpgradeCheckScene")

def isHighEndDevice(context):
    '''
    @summary: 判断是否为高端设备
    @param context: 上下文环境
    '''

    devType = getDevType(context)
    if "18" in devType or "HVS" in devType:
        return True
    return False

def getSceneDataExchangeObj(context):
    '''
    @summary: 获取场景化数据传递的对象
    @param context: 上下文对象
    '''
    return context.get("SceneDataExchangeInstance")

def getDeviceClass(context):
    '''
    @summary: 获取设备类型（归类）
    @param context: 上下文对象
    '''

    devVersion = getCurVersion(context)

    if "V" not in devVersion:
        return DevClass.COMMON

    devVersion = devVersion[devVersion.index("V"):]
    vVersion = devVersion[0:4]
    if vVersion == "V100":
        if isHighEndDevice(context):
            return DevClass.V2
        else:
            return DevClass.V1
    if vVersion == "V200":
        return DevClass.V2
    elif vVersion >= "V300":
        return DevClass.V3V5

    return DevClass.COMMON
