﻿# -*- coding: UTF-8 -*-

def getMsg(lang, msg, args = ""):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @return: 经过国际化处理后的消息
    '''
    errMsg = "\n--"

    try:
        if not MESSAGES_DICT.has_key(msg):
            return errMsg

        localeDict = MESSAGES_DICT.get(msg)
        if not localeDict.has_key(lang):
            return errMsg

        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg

    except:
        return errMsg


MESSAGES_DICT = {
"query.result.abnormal":
    {
        "zh":u"\n获取信息失败。",
        "en":"\nThere is an error in getting information.",
    }
}
