# -*- coding: UTF-8 -*-

from function import StorageContextUtil
from function import  StorageCliUtil
from function import  StorageResource

import os
import traceback
from defusedxml import ElementTree

def execute(context):
    '''
    @summary: 入口程序
    @param context: 上下文对象
    '''

    logger = StorageContextUtil.getLogger(context)
    lang = StorageContextUtil.getLang(context)
    try:
        #获取命令信息列表
        cmdDict = _parseCmdConf(context)
        if not cmdDict:
            return True, ""

        #执行命令并保存
        cmdRetDict = {}
        #获取设备SN
        devSN = StorageContextUtil.getDevSN(context)
        ssh = StorageContextUtil.getSSH(context)
        for item, cmd in cmdDict.items():
            executeFlag, cmdRet = StorageCliUtil.excuteCmdInCliMode(ssh, cmd)
            logger.info("[saveDevSceneData] cmd[%s] execute result is: %s" %(cmd, str(executeFlag)) )
            #不支持此特性，不需要保存信息
            if executeFlag == StorageCliUtil.RESULT_NOSUPPORT:
                continue
            #单条命令执行失败，直接返回错误
            elif executeFlag != True:
                return False, StorageResource.getMsg(lang, "query.result.abnormal")

            DevCmdItem = devSN + "_" + item
            cmdRetDict[DevCmdItem] = cmdRet

        #所有命令全部执行成功，保存数据
        _saveDeviceInfo(context, cmdRetDict)
        return True, ""
    except:
        logger.error("[saveDevSceneData] error: " + traceback.format_exc())
        return False, StorageResource.getMsg(lang, "query.result.abnormal")

def _saveDeviceInfo(context, cmdRetDict):
    '''
    @summary: 保存相关的设备信息
    @param context: 上下文对象
    '''
    logger = StorageContextUtil.getLogger(context)
    sceneDataInstance = StorageContextUtil.getSceneDataExchangeObj(context)
    for item, cmdRet in cmdRetDict.items():
        logger.info("[_saveDeviceInfo] save item: " + item)
        sceneDataInstance.saveKV(item, cmdRet)

def _parseCmdConf(context):
    '''
    @summary: 解析命令配置
    @param context: 上下文对象
    '''
    cmdDict = {}
    configFile = _getXmlFilePath(context)
    #判断文件是否存在
    if not os.path.exists(configFile):
        return cmdDict

    #获取所有的element
    root = ElementTree.parse(configFile)
    cmdItemList = root.getiterator("command")
    #获取第一层信息：CollectItem列表
    for cmdConfig in cmdItemList:
        cmdItem = cmdConfig.attrib["item"].strip()
        cmd = cmdConfig.attrib["cmd"].strip()
        cmdDict[cmdItem] = cmd

    return cmdDict

def _getXmlFilePath(context):
    '''
    @summary: 获取xml文件路径
    @param context: 上下文对象
    '''

    logger = StorageContextUtil.getLogger(context)
    deviceClass = StorageContextUtil.getDeviceClass(context)
    scriptPath = os.path.split(os.path.realpath(__file__))[0]
    configFile = scriptPath + os.sep + "config" + os.sep + "commandConf_%s.xml" % deviceClass
    logger.info("[_getXmlFilePath] file path is:" + configFile)
    return configFile
