# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        PCIe端口状态检查：
        1 如果PCIe端口不存在表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    portName = "PCIe"
    
    try:
        cmd = "show port general physical_type=PCIE"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.port.info", portName)
            logger.logNoPass("Cannot get information about PCIe port")
            return common.getUpgEvaluationRs(False, cliRet, checkRet[2])
        
        for line in cliRetLinesList:
            portId = line["ID"]
            healthStatus = line["Health Status"]
                
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(lang, "port.health.status.abnormal", (portName, portId, healthStatus))
                logger.logNoPass("The Health Status of PCIe port [%s] is abnormal (Health Status:%s)" 
                     % (portId, healthStatus))
            
        if flag:
            logger.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg) 
                                  
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
