# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
    ISCSI端口检查：
        1 如果ISCSI端口不存在表示正常；
        2 Health Status必须为Normal。端口Running Status为Link Down时表示正常，
                        当为Link Up时，工作速率为10Mbps，100Mbps，1000Mps或10000Mps时表示正常；
        3 其它情况均属于不正常状态。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet =""
    errMsg = ""
    portName = "ISCSI"
    
    try:
        cmd = "show port general physical_type=ETH logic_type=Host_Port"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.port.info", portName)
            LOGGER.logNoPass("Cannot get information about ISCSI port")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)
        
        for line in cliRetLinesList:
            portId = line["ID"]
            healthStatus = line["Health Status"]
            runningStatus = line["Running Status"]
            workingRate = line["Working Rate(Mbps)"]
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "port.health.status.abnormal", (portName, portId, healthStatus))
                LOGGER.logNoPass("The Health Status of ISCSI port [%s] is abnormal (Health Status:%s)" 
                     % (portId, healthStatus))
            
            if runningStatus == common.STATUS_LINK_UP:
                if workingRate not in ["10", "100", "1000", "10000"]:
                    flag = False
                    errMsg += common.getMsg(LANG, "port.working.rate.abnormal", (portName, portId, workingRate))
                    LOGGER.logNoPass("The Working Rate of ISCSI port [%s] is abnormal (Working Rate:%sMbps)" 
                         % (portId, workingRate))
        
        if flag:
            LOGGER.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
