# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
import os

def execute(context):
    '''
                    异构链路接入检查：
        1 所有控制器SESSION的Status不为INIT正常；
        2 存在SESSION的Status为INIT不正常；
        3 其他情况未检查；
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    #检查当前版本是否涉及当前检查项
    if not common.needCheckItem(contextUtil.getCurVersion(context), __file__):
        logger.logInfo('The current version is not involved the check item')
        return common.getUpgEvaluationRsNoInvolved()
    
    #步骤1：获取所有控制器IP和ID
    ctrlIpAndIdMap = contextUtil.getItem(context, "allCtrlsIp")
    logger.logInfo("All ip is %s" % str(ctrlIpAndIdMap))
    if not ctrlIpAndIdMap:
        #无法获取控制器ip
        errMsg = common.getMsg(lang, "query.result.abnormal")
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, "", errMsg)
    
    #将回显和控制器信息拼接起来
    cliRetList = []
    resultList = []
    for contrlInfo in ctrlIpAndIdMap:
        ctrlId = contrlInfo[0]
        ctrlIpv4 = contrlInfo[1]
        ctrlIpv6 = contrlInfo[2]
        #检查可能结果：通过，不通过，未检查
        checkRet = check(context, (ctrlIpv4,ctrlIpv6), ctrlId)
        
        if checkRet[0] != cliUtil.RESULT_NOCHECK:
            cliRetList.append(common.CONTROLLER_INFO % (ctrlId))
            cliRetList.append(checkRet[1] + "\n")

        resultList.append(checkRet[0])
        #中间变量保存显示信息。
        midMsg = checkRet[2]
        if checkRet[0] is True:
            midMsg = common.getMsg(lang, "controller.check.pass")
        errMsg += common.getMsg(lang, 'title.controller', ctrlId) + midMsg + os.linesep
        
    flag = common.getCheckResult(resultList)
    logger.logInfo("resultList flag is:%s" % str(resultList))
    cliRet = '\n'.join(cliRetList)   
    return common.getUpgEvaluationRs(flag, cliRet, errMsg)
       
def check(context, ctrlIps, ctrlId):
    '''
                    单个控制器的异构链路接入检查：
        1 控制器SESSION的Status不为INIT正常；
        2 存在SESSION的Status为INIT不正常；
        3 其他情况未检查；
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    
    flag = True
    cliRet = ""
    errMsg = ""
    logger.logInfo("start checking controller[%s]" %ctrlId)
    
    try:
        curCtrlIp = contextUtil.getCurCtrlIp(context)
        if curCtrlIp == ctrlIps[0] or curCtrlIp == ctrlIps[1]:#当前控制器直接获取
            cli = contextUtil.getSSH(context)
        else:#创建cli连接，先使用ipv4创建，如果失败再用ipv6创建
            cli = contextUtil.createCliConnection(context, ctrlIps[0])
            if cli is None:
                cli = contextUtil.createCliConnection(context, ctrlIps[1])
        
        if cli is None:
            logger.logInfo("create controller [%s] cli connection failed" %ctrlId)
            errMsg = common.getMsg(lang, "cannot.create.controller.cli")
            return (cliUtil.RESULT_NOCHECK, "", errMsg)
    
        cmd = "mp show link"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.executeCmdInDebugMode(cli, cmd, True, lang, contextUtil.getDeveloperPwd(context))
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return (checkRet[0], checkRet[1], common.getMsg(lang, "query.controller.result.abnormal"))
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalDebugRet(cliRet)
        logger.logInfo("get debug ret list:%s" %str(cliRetLinesList))
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.heterogeneous.link.info")
            logger.logNoPass("Cannot get heterogeneous link information of controller[%s]" %ctrlId)
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            heterType = line["Type"]
            status = line["Status"]
            
            #存在SESSION的状态为INIT的不通过
            if heterType == "SESSION" and status == common.STATUS_INIT:
                flag = False
                errMsg += common.getMsg(lang, "check.heterogeneous.link.status.init", status)
                logger.logNoPass("The controller [%s] session status of heterogeneous link is INIT" 
                     % ctrlId)
                break
        
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return (False, cliRet, common.getMsg(lang, "query.controller.result.abnormal"))
    
    finally:
        if curCtrlIp != ctrlIps[0] and curCtrlIp != ctrlIps[1]:
            cliUtil.closeCliConnection(cli)
