# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
                      快照健康状态检查：
        1 如果快照不存在表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show snapshot general |filterColumn include columnList=ID,Health\sStatus"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        cliRetLinesList = cliUtil.getHorizontalNostandardCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.snapshot.info")
            logger.logNoPass("Cannot get information about snapshot")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)

        for line in cliRetLinesList:
            Id = line["ID"]
            healthStatus = line["Health Status"]
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(lang, "snapshot.health.status.abnormal", (Id, healthStatus))
                logger.logNoPass("The Health Status of snapshot [%s] is abnormal (Health Status:%s)" 
                     % (Id, healthStatus))
                
        if flag:
            logger.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
