# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        文件系统版本检查: 
         存在文件系统，检查为警告，否则通过。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cli = contextUtil.getSSH(context)
        
        curVersionCheckList = ["V300R002C10SPC100","V300R002C10SPC200"]
        targetVersionCheckList = ["V300R003C10","V300R003C10SPC100","V300R003C20","V300R003C20SPC100","V300R003C20SPC200"]
        curVersion = contextUtil.getCurVersion(context)
        targetVersion = contextUtil.getTargetVersion(context)
        
        if curVersion not in curVersionCheckList or targetVersion not in targetVersionCheckList:
            logger.logInfo("The check item not support the version(%s) and targetVersion(%s)." %(curVersion, targetVersion))
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
        cmd = "show file_system general"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, False, lang)
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            logger.logInfo("No file system is configured.")
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        logger.logNoPass("The file system is configured.")
        errMsg = common.getMsg(lang, "file.system.configured")
        return common.getUpgEvaluationRs(cliUtil.RESULT_WARNING, cliRet, errMsg)

    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
