# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
        Hotspare容量检查: 
        1 如果硬盘域不存在表示正常；
        2 Used Hot Spare Capacity为0表示正常或者硬盘域所有硬盘均为正常盘(硬盘的Health Status
        为Normal且Running Status为Online)表示正常;
        3 其它情况均属于不正常状态。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show disk_domain general"
        logger.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        if checkRet[0] != True: 
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.disk.domain.info")
            logger.logNoPass("Cannot get information about disk domain")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)

        for line in cliRetLinesList:
            Id = line["ID"]
            usedHotSpareCapacity = line["Used Hot Spare Capacity"]
            realUsedHotSpareCapacity = common.getRealCapacity(usedHotSpareCapacity)
            if len(realUsedHotSpareCapacity) == 0:
                flag = False
                errMsg += common.getMsg(lang, "cannot.get.used.hot.spare.capacity.info", Id)
                logger.logNoPass("Cannot get information about Used Hot Spare Capacity of POOL [%s]" % Id)
            elif not float(realUsedHotSpareCapacity) == float(0):
                flag, cliRetItem, _ = checkDiskDomainStatus(cli, Id, lang, logger)
                cliRet = "\n".join([cliRet,cliRetItem])
                logger.logInfo("cliRetItem is [%s]" % unicode(cliRetItem))
                if flag != True:
                    errMsg += common.getMsg(lang, "pool.used.hot.spare.capacity.abnormal", (Id, usedHotSpareCapacity))
                    logger.logNoPass("The Used Hot Spare Capacity of POOL [%s] is more than 0 (Capacity:%s)" 
                         % (Id, usedHotSpareCapacity))
        
        if flag:
            logger.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
 
    
def checkDiskDomainStatus(cli, diskdomain, LANG, logger): 
    '''
    @summary: 检查disk_domain下的硬盘状态是否正常
    @param diskdomain:硬盘域ID
    @return: 硬盘状态
             CLI回显        
                                  错误信息
    '''  
    flag = True
    cliRet = ""
    errMsg = ""
    
    cmd = "show disk in_domain disk_domain_id=%s |filterRow column=Health\sStatus predict\
=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict\
=not predict2=equal_to value=Online" % diskdomain
        
    logger.logExecCmd(cmd)
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if checkRet[0] != True: 
        logger.logSysAbnormal()
        return checkRet
    
    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (flag, cliRet, errMsg)
    flag = False
    return (flag, cliRet, errMsg)
