# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

##磁盘利用率的最大值和平均值的阈值定义
G_MaxDiskUsage = 80
G_AvgDiskUsage = 60

def execute(context):
    '''
    @summary: 磁盘利用率检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    try:
        flag = True
        errMsg = ""
        tlv = contextUtil.getTlvObj(context)
        checkItem = "CHECK_DISK_USAGE"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]#根据检查项获取配置字典值
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))

        for record in recs:
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            itemKey = checkState(result)
            #根据模块返回值获取对应的字典值,如果失败返回None
            itemVal = itemDict.get(itemKey, None)
            if itemVal is None:
                errMsg += common.getMsg(lang, "check.result.abnormal", nodeId)
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemVal.get("status", None)
            if status is True:
                continue
            flag = False
            errMsg += common.getMsg(lang, itemVal["msg"], nodeId)
        
        if flag == True:
            cliRet = "The disk usage is normal"
        else:
            cliRet = "The disk usage is too high"
        
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))

def checkState(diskUsage):
    """
    @summary: 根据返回消息，转化成对应key值。
    """
    #结果超时处理流程
    if diskUsage.lower() == "timeout":
        return diskUsage 
    
    diskUsageStrList = diskUsage.split(",")
    
    #结果异常处理流程
    if len(diskUsageStrList) == 0 or len(diskUsageStrList) > 2:
        return diskUsage
    for usage in diskUsageStrList:
        if not usage.isdigit():
            return diskUsage
    
    diskUsageList = [int(usage) for usage in diskUsageStrList]
    #结果正常处理流程
    usage = diskUsageList[0]
    avgUsage = 0
    if len(diskUsageList) == 2:
        avgUsage = diskUsageList[1]
        
    if usage <= G_MaxDiskUsage and avgUsage <= G_AvgDiskUsage:
        return "True"
    else:
        return "False"
            