# -*- coding: UTF-8 -*-

#===============================================================================
# 该文件包含一些导出阵列文件的公共方法。                                                                                   14：20 2016/2/5
#===============================================================================
from frame.cli import cliUtil
from frame.common import common


  
def downLoadFile(sftp, filePath, localPath):
    '''@summary:下载filePath到本地（localPath）
       @return:flag(True:下载成功，False：下载失败) 
    '''
    flag = True
    try:
        sftp.getFile(filePath, localPath, None)
    except:
        flag = False
    return flag

def getRemotePath(rec):
    '''
    @summary: 获取阵列端的文件名称和路径
    @param cliRet:  devObj=上下文对象
    @return: name:阵列端产生的文件名称
             path:阵列端产生的文件的路径
    '''
    path = ""
    cliRetList = rec.splitlines()
    for line in cliRetList:
        #判断回显是否正常
        if common.COLLECT_INFO_RECROD_STANDARD in line:
            tempList = line.split(" : ")            
            path = tempList[1].strip()
            break
    
    return path


def downloadStorageFile(lang, cli, sftp, logger, exportType, localConfigFile):
    '''
    @summary: 下载远端文件到指定路径
    '''
    errMsg = ""
    
    try:
        tempCmd = "show file export_path file_type=%s" % (exportType)
        checkRet = cliUtil.excuteCmdInCliMode(cli, tempCmd, True, lang)  
        cliRet = checkRet[1]
        if checkRet[0] != True or common.COLLECT_INFO_RECROD_STANDARD not in cliRet: 
            return (cliUtil.RESULT_NOCHECK, checkRet[1], checkRet[2])  
        
        remotePath = getRemotePath(cliRet)
        successFlag = downLoadFile(sftp, remotePath ,localConfigFile)
        logger.logInfo("downlod %s result is [%s]" % (exportType, successFlag))
        
        if successFlag != True:
            successFlag = cliUtil.RESULT_NOCHECK
            errMsg = common.getMsg(lang, "download.file.failed", exportType)
            
        return (successFlag, cliRet, errMsg)
    
    except Exception, exception:     
        logger.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "download.file.excption", exportType))


