# -*- coding: UTF-8 -*-

from java.util import ArrayList as JavaList
from java.lang import String
from com.huawei.ism.tool.framework.platform.exception import ToolException
from cbb.frame.util.common import wrapAllExceptionLogged

class TlvConnection(object):
    RE_CONNECTION_TIMES = 3
    TLV_PORT_DEFAULT = 8080
    TLV_CAN_NOT_CONNECT_CODE = "1073949185" #与设备通信异常，请检查网络连接或设备状态是否正常
    _instance = None
    _tlv = None
       
    def __new__(cls, *args, **kwargs):
        if cls._instance is None:
            cls._instance = super(TlvConnection, cls).__new__(cls, *args, **kwargs)
        return cls._instance
    
    def __init__(self, connectorFactory, ip, tlvPort, ssl = True, innerIps = None):
        self.connectorFactory = connectorFactory
        #高端场景，通过内部IP创建连接
        if innerIps:
            tempList = innerIps.split(",")
            innerIpList = JavaList()
            for innerIp in tempList:
                innerIpList.add(String(innerIp))
            self.ip = innerIpList
        else:
            self.ip = ip
        self.tlvPort = tlvPort
        self.ssl = ssl
                
    def create(self, user, pawd):
        reConnectionTimes = 0
        while self._tlv is None and reConnectionTimes < TlvConnection.RE_CONNECTION_TIMES:
            tlvConnector = self.connectorFactory.createTlvConnector(self.ip, TlvConnection.TLV_PORT_DEFAULT, user, pawd, self.ssl)
            self._tlv = tlvConnector.getConnectionNoException()
            reConnectionTimes += 1
        del pawd
        return self._tlv

    @wrapAllExceptionLogged(logger=None)
    def close(self):
        if self._tlv is not None:
            try:
                self._tlv.close()
            finally:
                self._tlv = None
        return
    
    def getTlv(self, user, pawd):
        try:
            if self._tlv is None:
                self.create(user, pawd)
        except:
            raise Exception(self.TLV_CAN_NOT_CONNECT_CODE, "")
        
        return self._tlv

class TlvConnectionSVP(object):
    RE_CONNECTION_TIMES = 3
    IP_DEFAULT = "172.17.126.11"
    PORT_DEFAULT = "19002"
    DEFAULT_FLAG = "186042"
    TLV_CAN_NOT_CONNECT_CODE_SVP = "TLV_CAN_NOT_CONNECT_CODE_SVP" #与SVP建立连接异常
    
    _instance = None
    _tlv = None
       
    def __new__(cls, *args, **kwargs):
        if cls._instance is None:
            cls._instance = super(TlvConnectionSVP, cls).__new__(cls, *args, **kwargs)
        return cls._instance
    
    def __init__(self, connectorFactory, deviceType, sn, ip=IP_DEFAULT, tlvPort=PORT_DEFAULT, session=DEFAULT_FLAG):
        self.connectorFactory = connectorFactory
        self.deviceType = "svp"
        self.sn = sn + "svp"
        self.ip = ip
        self.tlvPort = tlvPort
        self.session = session
                
    def create(self):
        try:
            tlvConnector = self.connectorFactory.createTlvConnectorSVP(
               self.ip, self.tlvPort, self.session, self.deviceType, self.sn)
            self._tlv = tlvConnector.getConnectionSVP()
            return self._tlv
        except ToolException:
            raise Exception(self.TLV_CAN_NOT_CONNECT_CODE_SVP, "")
        return None

    @wrapAllExceptionLogged(logger=None)
    def close(self):
        if self._tlv is not None:
            try:
                self._tlv.close()
            finally:
                self._tlv = None
        return
    
    def getTlv(self):
        if self._tlv is None:
            self.create()
        return self._tlv
