# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
    @summary: 检查每个引擎保险箱盘是否为4K盘
    @param context: 上下文
    @return: 
        flag:通过与否
        cliRetToShow:回显信息
        errMsg:错误提示信息
            型号：所有型号：5300V35500V35600V35800V36800V3
            版本：V3R2C00\V3R2C00SPC100\V3R2C10
    '''
    
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    cliRetToShow = ""
    errMsg = ""
    
    involVersion = ["V300R002C00","V300R002C00SPC100","V300R002C10"]
    
    try:
        #检查是否在版本范围内
        getDevVersionRet = common.getDevVersion(cli, LANG, LOGGER)
        if not getDevVersionRet[0]:
            return common.getUpgEvaluationRs(getDevVersionRet[0], getDevVersionRet[2], common.getMsg(LANG, "cannot.get.version"))
        
        cliRetToShow += getDevVersionRet[2]
        devVersion = getDevVersionRet[1]
        if devVersion not in involVersion:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRetToShow, errMsg)
        
        #检查每个引擎保险箱盘是否为4K盘
        diskSystem_cmd = "show disk system"
        LOGGER.logExecCmd(diskSystem_cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, diskSystem_cmd, True, LANG)
        cliRetToShow += checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], cliRetToShow, checkRet[2])
        
        #解析回显信息
        cliRet = checkRet[1]
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.cofferdisk")
            LOGGER.logNoPass("Cannot get information about coffer disk.")
            return common.getUpgEvaluationRs(False, cliRetToShow, errMsg)
        
        #获取每个所有引擎下的保险箱盘
        engineCofferDict = {}
        for cofferDisk in cliRetLinesList:
            cofferDiskID = cofferDisk.get("ID")
            coffDiskIDList = cofferDiskID.split(".")
            if coffDiskIDList[0] not in engineCofferDict:
                tempIDList = []
                tempIDList.append(cofferDiskID)
                engineCofferDict[coffDiskIDList[0]] = tempIDList
            else:
                engineCofferDict[coffDiskIDList[0]].append(cofferDiskID)
        LOGGER.logInfo("Each engine ID and coffer disks dictionary is :" + unicode(engineCofferDict))     
           
        #解析每个引擎的保险箱盘是否都是4K盘
        for engineID in sorted(engineCofferDict.keys()):
            diskIDList = engineCofferDict.get(engineID)
            flag4K, cliRet4K, errMsg4K = checkAll4KDisk(cli, diskIDList, LANG, LOGGER)
            cliRetToShow += cliRet4K
            if errMsg4K:
                flag = False
                errMsg += errMsg4K
                continue
            if flag4K:
                flag = False
                errMsg += common.getMsg(LANG, "engine.allcoffer.4Kdisk", engineID)
                LOGGER.logNoPass("Engine ID:[%s] coffer disks are all 4K disks." %engineID)
                
        if flag:
            LOGGER.logPass()
            
        return common.getUpgEvaluationRs(flag, cliRetToShow, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetToShow, common.getMsg(LANG, "query.result.abnormal"))


def checkAll4KDisk(cli, coffDiskList, LANG, LOGGER):
    '''
    @summary: 检查coffDiskList列表中的盘是否都是4K盘
    @param context: cli, coffDiskList, LANG, LOGGER
    @return: 
        flag:通过与否
            True：全为4K盘
            False：非全为4K盘
        cliRet:回显信息
        errMsg:错误提示信息
    '''
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    for diskID in coffDiskList:
        diskInfo_cmd = "show disk general disk_id=%s" % diskID
        LOGGER.logExecCmd(diskInfo_cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, diskInfo_cmd, True, LANG)
        cliRet += checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            errMsg += common.getMsg(LANG, "cannot.get.one.cofferdisk", diskID)
            LOGGER.logInfo("Can not get coffer disk info ID:" + unicode(diskID))
            continue
        
        cliRetInfoDictList = cliUtil.getVerticalCliRet(checkRet[1])
        for item in cliRetInfoDictList:
            sectorSize = item["Sector Size"]
            if sectorSize:
                sectorSize = int(sectorSize.split(".")[0])
                break
                
        if sectorSize != 4:
            flag = False
            break
        
    return (flag, cliRet, errMsg)
